# coding=utf-8

import os
from sandbox import sdk2
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.frontarc.MarketFrontYammyPackageTaskArc import MarketFrontYammyPackageTaskArc


class MarketFrontYammyPublishS3Arc(MarketFrontYammyPackageTaskArc):
    """
    Таск публикации пакета в npm
    """

    alias = "publish"

    class Parameters(MarketFrontYammyPackageTaskArc.Parameters):
        with sdk2.parameters.Group("Публикация") as publish:
            s3_bucket = sdk2.parameters.String("Бакет s3", required=True)
            s3_prefix = sdk2.parameters.String("Префикс в бакете", required=True)

        with sdk2.parameters.Output:
            result = sdk2.parameters.String("Полный путь публикации")

    def setup_env(self):
        super(MarketFrontYammyPublishS3Arc, self).setup_env()
        os.environ['DIST_DIR'] = self.output_dir

    def on_enqueue(self):
        self.prepend_tags('publish-s3')
        super(MarketFrontYammyPublishS3Arc, self).on_enqueue()

    def run_task(self):
        (stdout, error) = self.run_command()

        if error:
            raise error

        with self.timer("yammy:s3-upload"):
            rich_check_call(
                ["yammy", "ci", "s3-upload", self.Parameters.s3_bucket, self.Parameters.s3_prefix],
                self, "s3-upload", cwd=self.APP_SRC_DIR
            )

        with self.timer("result"):
            self.Parameters.result = "s3://{}/{}".format(self.Parameters.s3_bucket, self.Parameters.s3_prefix)
