# coding=utf-8

import json
import logging

from sandbox import sdk2
from sandbox.sdk2 import Vault

from sandbox.projects.market.frontarc.MarketFrontYammyBaseArc import MarketFrontYammyBaseArc
from sandbox.projects.sandbox_ci.utils.request import send_request
from sandbox.projects.market.frontarc.helpers.ArcanumApi import CheckStatus

# FIXME: переписать для арка
class MarketFrontYammyStartMtArc(MarketFrontYammyBaseArc):
    """
    Запуск пайплайна для монорепы
    """

    TSUM_TOKEN_VAULT_KEY = "robot-metatron-tsum-token"
    TSUM_MT_API_URL = "https://tsum.yandex-team.ru/api/multitestings/project/{project}/environments/{name}/createOrRestart"
    TSUM_RESULT_URL = "https://tsum.yandex-team.ru/pipe/projects/{project}/multitestings/environments/{name}/launch/{id}"

    _pipeline_id = None

    class Parameters(MarketFrontYammyBaseArc.Parameters):
        yammy_build_meta = None
        yammy_prebuilt = None

        with sdk2.parameters.Group('TSUM') as tsum:
            tsum_project_id = sdk2.parameters.String("Название проекта", required=True)
            tsum_pipeline_id = sdk2.parameters.String("Тип пайплайна", required=True)

    @property
    def tsum_pipeline_name(self):
        return "{}-{}".format(self.ticket.lower(), self.Parameters.pr_number)

    @property
    def tsum_api_url(self):
        return self.TSUM_MT_API_URL.format(
            project=self.Parameters.tsum_project_id,
            name=self.tsum_pipeline_name
        )

    @property
    def _tsum_result_url(self):
        return self.TSUM_RESULT_URL.format(
            project=self.Parameters.tsum_project_id,
            name=self.tsum_pipeline_name,
            id=self._pipeline_id,
        )

    def on_enqueue(self):
        super(MarketFrontYammyStartMtArc, self).on_enqueue()
        self.prepend_tags("yammy-pipeline")

    def bootstrap(self):
        pass

    def run_task(self):
        headers = {
            "Authorization": Vault.data(self.TSUM_TOKEN_VAULT_KEY),
            "Content-Type": "application/json"
        }

        data = {
            "name": self.tsum_pipeline_name,
            "type": "USE_EXISTING_PIPELINE",
            "pipelineId": self.Parameters.tsum_pipeline_id,
            "resources": {
                "fd4f152f-9f11-4b91-8a35-e58503b6bdf6": {
                    "tickets": [self.ticket]
                },
                # FrontYammyParameters
                "849d4caa-66a2-499c-a902-202e79e2ebb2": {
                    "repoRoot": self.Parameters.root_path,
                    "appBranch": {"name": self.Parameters.head_branch},
                    "prNumber": self.Parameters.pr_number,
                    "useMergeCommit": False,
                },
                "8fb5121f-6fe3-469e-a715-5dcff1fb448e": {
                    "version": self.Parameters.node_version,
                    "ubuntuVersion": self.Parameters.ubuntu_version,
                    "nodeEnv": "production",
                    "nodeDebug": ""
                }
            }
        }

        logging.debug("TSUM request: {}\n{}".format(self.tsum_api_url, data))

        with self.timer("request"):
            res = send_request(
                "post",
                self.tsum_api_url,
                headers=headers,
                data=json.dumps(data)
            )

        logging.debug("TSUM response: {}".format(res.text))

        res.raise_for_status()

        self._pipeline_id = len(res.json()["launches"])

        self.set_info('<a class="status status_success" href="{}">Go to TSUM</a>'
                      .format(self._tsum_result_url), do_escape=False)

    def update_status(self, state, description, type=None, url=None):
        if state == CheckStatus.success:
            url = self._tsum_result_url

        return super(MarketFrontYammyStartMtArc, self).update_status(state, description, type, url)
