# coding=utf-8

import os
import logging

from sandbox import sdk2

from sandbox.projects.market.frontarc.MarketFrontYammyBaseArc import MarketFrontYammyBaseArc
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call


class MarketFrontYammyTaskArc(MarketFrontYammyBaseArc):
    """
    Публикация мета-информации о сборке
    """

    TASK_ROOT_DIR = None

    class Parameters(MarketFrontYammyBaseArc.Parameters):
        with sdk2.parameters.Group('Task') as task:
            task_command = sdk2.parameters.String("Команда для запуска", required=True)
            task_root = sdk2.parameters.String("Директория запуска команды")

    def setup_env(self):
        super(MarketFrontYammyTaskArc, self).setup_env()

        if self.Parameters.task_root:
            self.TASK_ROOT_DIR = os.path.join(self.APP_SRC_DIR, self.Parameters.task_root)
        else:
            self.TASK_ROOT_DIR = self.APP_SRC_DIR

        os.environ["TASK_ROOT_DIR"] = os.path.join(os.environ["ROOT_PATH"], self.TASK_ROOT_DIR)

        os.environ["PATH"] = "{}:{}".format(
            os.path.join(os.environ["TASK_ROOT_DIR"], 'node_modules', '.bin'),
            os.environ["PATH"],
        )

    def run_task(self):
        logging.debug("Running task '{}' at '{}'".format(self.Parameters.task_command, self.TASK_ROOT_DIR))

        with self.timer("command"):
            rich_check_call(
                ["bash", "-c", self.Parameters.task_command],
                self, "task_run", cwd=self.TASK_ROOT_DIR
            )
