# coding=utf-8

import os
import logging

from sandbox import sdk2
from sandbox.common.types import misc as ctm
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.frontarc.helpers.node import get_node_path, create_node_selector
from sandbox.projects.market.frontarc.helpers.ubuntu import create_ubuntu_selector, setup_container
from sandbox.projects.common.arcadia import sdk as arcadia_sdk

DISK_SPACE = 3 * 1024  # 3 Gb

class MarketPlannerCIArc(sdk2.Task):
    """
    Таска для запуска првоерок планера
    """

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        disk_space = DISK_SPACE

    class Parameters(sdk2.Task.Parameters):
        ubuntu_version = create_ubuntu_selector()
        node_version = create_node_selector()

        # FIXME: утащить изменения в наши слои, пересобрать их, прописать новые айдишники, удалить этот параметр.
        _container = sdk2.parameters.Container(
            "Environment LXC container resource",
            default_value=2035418670,
            required=True
        )
        arcadia_url = sdk2.parameters.ArcadiaUrl(
            "Arcadia repository url",
            default_value="arcadia-arc:/#trunk",
            required=True
        )
        app_dir = sdk2.parameters.String(
            "App dir",
            default="market/infra/market-planner/webapp",
            required=True
        )
        command = sdk2.parameters.String(
            "Команда для запуска",
            description="Например, npm install && npm run lint:eslint",
            required=True
        )

    def on_enqueue(self):
        super(MarketPlannerCIArc, self).on_enqueue()
        setup_container(self)

    def _prepare_node(self):
        node_path = get_node_path(self.Parameters.node_version)
        os.environ["PATH"] = "{}:{}".format(node_path, os.environ["PATH"])

    def _test(self, app_path):
        rich_check_call(["bash", "-c", self.Parameters.command], self, "test", cwd=app_path)

    def on_prepare(self):
        self._prepare_node()

    def on_execute(self):
        with arcadia_sdk.mount_arc_path(self.Parameters.arcadia_url) as arcadia_root:
            arcadia_app_path = os.path.join(arcadia_root, self.Parameters.app_dir)
            self._test(arcadia_app_path)
