# -*- coding: utf-8 -*-

import logging
import requests

from sandbox import sdk2


class MarketSpvConfigArc(sdk2.Task):
    """
    Задача для публикации конфигов вендорских спецпроектов маркета
    """
    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("Настройки приложения") as app_settings:
            url = sdk2.parameters.String(
                "URL генератора спецпроектных конфигов",
                default_value="http://spv.in.yandex.net/api/campaign/push?source=public",
                required=True
            )

            telegram_secret = sdk2.parameters.YavSecret(
                "Yav secret с токенами телеграма",
                description="Ожидается, что в секрете будут ключи: telegram_bot_token, telegram_channel_id",
                default_value="sec-01evxm2st5k2g23jawasedpmhy"
            )

    def on_execute(self):
        url = self.Parameters.url

        logging.info("Make request: {}".format(url))

        r = requests.get(url)

        logging.info('Request finished with {} {}'.format(r.status_code, r.reason))
        logging.debug('Response:\n{}'.format(r.text))

        j = r.json()

        instruments_dict = {
            'promo_badge': 'Бейдж',
            'electro': 'Электричка',
            'upsale': 'Апсейл',
            'banner': 'Баннер',
            'custom_filter': 'Кастомный фильтр',
            'monobrand': 'Монобренд',
            'popup': 'Попап'
        }

        report = []

        report.append('Опубликованые вендорские инструменты (тач/деск):')
        report.append('')

        instruments = {}

        for platform in j:
            for instrument in j[platform]:
                c = len(j[platform][instrument]['bucket'])

                if c > 0:
                    if instrument not in instruments:
                        instruments[instrument] = {}

                    instruments[instrument][platform] = len(j[platform][instrument]['bucket'])

        for instrument in instruments:
            instrument_name = instrument

            if instrument in instruments_dict:
                instrument_name = instruments_dict[instrument]

            report.append('{}: {}/{}'.format(
                instrument_name,
                instruments[instrument]['touch'],
                instruments[instrument]['desktop']
            ))

        logging.info('^^^^^^^^^^^^^^^^^^^^')

        for string in report:
            logging.info(string)

        logging.info('^^^^^^^^^^^^^^^^^^^^')

        secret = self.Parameters.telegram_secret

        telegram_bot_token = secret.data()["telegram_bot_token"]
        chat_id = secret.data()["telegram_channel_id"]

        apiUrl = 'https://api.telegram.org/bot{token}'.format(token = telegram_bot_token)

        urlGetChat = '{}/getChat'.format(apiUrl)
        urlSendMessage = '{}/sendMessage'.format(apiUrl)
        urlPinChatMessage = '{}/pinChatMessage'.format(apiUrl)

        request_data = {
            'chat_id': chat_id,
        }

        r = requests.post(urlGetChat, data=request_data)

        logging.info('Telegram send request finished with {} {}'.format(r.status_code, r.reason))
        logging.debug('Response:\n{}'.format(r.text))

        result = r.json()['result']

        pinned_message_text = ''

        if 'pinned_message' in result:
            pinned_message = result['pinned_message']
            pinned_message_text = pinned_message['text']

        text = '\n'.join(report)

        if pinned_message_text != text:
            request_data = {
                'chat_id': chat_id,
                'text': text,
                'disable_notification': True,
            }

            r = requests.post(urlSendMessage, data=request_data)

            logging.info('Telegram send request finished with {} {}'.format(r.status_code, r.reason))
            logging.debug('Response:\n{}'.format(r.text))

            result = r.json()['result']

            message_id = result['message_id']

            request_data = {
                'chat_id': chat_id,
                'message_id': message_id,
                'disable_notification': True,
            }

            r = requests.post(urlPinChatMessage, data=request_data)

            logging.info('Telegram send request finished with {} {}'.format(r.status_code, r.reason))
            logging.debug('Response:\n{}'.format(r.text))
