# -*- coding: utf-8 -*-

from sandbox import sdk2


class ArcPathWithoutFirstSlash(sdk2.parameters.String):
    @classmethod
    def cast(cls, value):
        if value is not None:
            # Убираем пробелы и слэши в начале и конце пути относительно корня аркадии
            return value.strip().strip("/")
        return value


class ArcDefaultParameters(sdk2.Task.Parameters):
    """
        Параметры, используемые для большинства тасок Market Front

        Usage:
        ```
        class Parameters(sdk2.Task.Parameters):
            arc_params = ArcDefaultParameters()
            # other code...
        ```
    """
    with sdk2.parameters.Group('Arcanum') as arcanum:
        task_description = sdk2.parameters.String("Короткое описание таски (аналог github context)", required=False, default="")
        head_branch = sdk2.parameters.String("Тестируемая ветка", required=False)
        pr_number = sdk2.parameters.Integer("Номер пулл-реквеста", required=False)
        commit_hash = sdk2.parameters.String("Хэш коммита, которому проставляется статус", required=False)
        diff_set_id = sdk2.parameters.String("id дифф-сета, используется для пачки коммитов подготовленных для ревью", required=False)
        root_path = ArcPathWithoutFirstSlash("Путь до приложения от корня arcanum", required=True, description="Слэши и пробелы в начале и в конце будут убраны автоматически")

    @property
    def project_name(self):
        return str(self.root_path).split("/")[-1]
