# -*- coding: utf-8 -*-

from sandbox import sdk2


class DeliveryPipelineParams(sdk2.Task.Parameters):
    """
        Параметры запуска релиза из релизной машины ЦУМа

        Usage:
        ```
        class Parameters(sdk2.Task.Parameters):
            dp_params = DeliveryPipelineParams()
            # other code...
        ```
    """
    with sdk2.parameters.Group('Delivery pipeline params') as delivery_pipeline_params:
        dpp_revision = sdk2.parameters.String("Ревизия", required=False)
        dpp_stableRevision = sdk2.parameters.String("Стабильная ревизия", required=False)
        dpp_lastRunningRevision = sdk2.parameters.String("Последняя ревизия, на которой сейчас запущен пайплайн", required=False)
        dpp_branch = sdk2.parameters.String("Собираемый бранч (в случае хотфикса)", required=False)
