# coding=utf-8

from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_start, rich_check_report
from sandbox.projects.market.frontarc.helpers.ubuntu import UBUNTU_TRUSTY
import os


def __check_size(file_path):
    # zopfli/brotli crash on emtpy files
    if os.path.getsize(file_path) == 0:
        with open(file_path, "w") as f:
            f.write("\n")


def compress_zopfli(task, file_path, filename, check_size=True):
    """
    compress file in zopfli
    :param task:instance of sandbox task (usually, `self`)
    :param file_path:absolute path to the file
    :param filename:desired filename
    :param check_size:check size of uploading file, cause compressor can fail on empty one
    :return:
    """
    if check_size:
        __check_size(file_path)

    (zopProc, zopLog) = rich_check_start(
        ["zopfli", "-i1000", file_path],
        task=task, alias="compress_gz_{}".format(filename)
    )

    def check_report():
        rich_check_report(zopProc, zopLog, task=task, alias="compress_gz_{}".format(filename))

    return zopProc, zopLog, check_report


def compress_brotli(task, file_path, filename, check_size=True):
    """
    compress file in brotli
    :param task:instance of sandbox task (usually, `self`)
    :param file_path:absolute path to the file
    :param filename:desired filename
    :param check_size:check size of uploading file, cause compressor can fail on empty one
    :return:
    """
    if check_size:
        __check_size(file_path)

    brotli_params = ["brotli", "--force", "--output", file_path + ".br", "--input", file_path] \
        if task.Parameters.ubuntu_version == UBUNTU_TRUSTY \
        else ["brotli", "--force", "--output=" + file_path + ".br", file_path]

    (broProc, broLog) = rich_check_start(
        brotli_params,
        task=task, alias="compress_br_{}".format(filename)
    )

    def check_report():
        rich_check_report(broProc, broLog, task=task, alias="compress_br_{}".format(filename))

    return broProc, broLog, check_report
