# coding=utf-8

from sandbox import sdk2
from sandbox.sdk2 import Vault
from sandbox.projects.common.solomon import push_to_solomon_v2


SOLOMON_TOKEN_VAULT_KEY = 'robot-metatron-solomon-token'


def _get_token():
    return Vault.data(SOLOMON_TOKEN_VAULT_KEY)

# options: {sensors, try_count}
def push_sensors(solomon_project, solomon_cluster, solomon_service, solomon_common_labels, **options):
    push_to_solomon_v2(
        token=_get_token(),
        params={
            'project': solomon_project,
            'cluster': solomon_cluster,
            'service': solomon_service,
        },
        common_labels=solomon_common_labels,
        **options
    )

def push_sensors_by_parameters(taskParameters, **options):
    if is_solomon_parameters_defined(taskParameters):
        options.update(select_solomon_parameters(taskParameters))
        push_sensors(**options)

def is_solomon_parameters_defined(taskParameters):
    return taskParameters.solomon_project and taskParameters.solomon_cluster and taskParameters.solomon_service

def select_solomon_parameters(taskParameters):
    return {
        'solomon_project': taskParameters.solomon_project,
        'solomon_cluster': taskParameters.solomon_cluster,
        'solomon_service': taskParameters.solomon_service,
        'solomon_common_labels': taskParameters.solomon_common_labels,
    }

def make_solomon_parameters(default_project='market-front', default_cluster=None, default_service=None):
    class SolomonParametersArc(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Solomon') as solomon_block:
            solomon_project = sdk2.parameters.String('Solomon project', default=default_project)
            solomon_cluster = sdk2.parameters.String('Solomon cluster', default=default_cluster)
            solomon_service = sdk2.parameters.String('Solomon service', default=default_service)
            solomon_common_labels = sdk2.parameters.Dict('Solomon common labels')

    return SolomonParametersArc

