# coding=utf-8

from sandbox import sdk2


UBUNTU_TRUSTY = "14"
UBUNTU_XENIAL = "16"
UBUNTU_VERSIONS = (UBUNTU_TRUSTY, UBUNTU_XENIAL)
UBUNTU_DEFAULT = UBUNTU_XENIAL


class MarketTrustyContainerParam(sdk2.parameters.Container):
    required = True
    default_value = 3358154004
    resource_type = "SANDBOX_CI_LXC_IMAGE"
    name = '_container'
    description = 'Container'
    platform = "linux_ubuntu_14.04_trusty"


class MarketXenialContainerParam(sdk2.parameters.Container):
    required = True
    default_value = 3358153827
    resource_type = "SANDBOX_CI_LXC_IMAGE"
    name = '_container'
    description = 'Container'
    platform = "linux_ubuntu_16.04_xenial"


def get_container(ubuntu_version=UBUNTU_DEFAULT):
    """
    Возвращает параметр для контейнера с убунтой.
    :param ubuntu_version:
    :return:
    """

    if ubuntu_version == UBUNTU_TRUSTY:
        return MarketTrustyContainerParam()
    elif ubuntu_version == UBUNTU_XENIAL:
        return MarketXenialContainerParam()
    else:
        raise Exception("Unsupported version {}".format(ubuntu_version))


def get_container_id(ubuntu_version=UBUNTU_DEFAULT):
    """
    Возвращает айди контейнера с убунтой.
    :param ubuntu_version:
    :return:
    """

    return get_container(ubuntu_version).default_value


def create_ubuntu_selector(default_ubuntu_version=UBUNTU_DEFAULT):
    with sdk2.parameters.String("Версия Ubuntu", required=True, multiline=True) as ubuntu_version:
        for version in UBUNTU_VERSIONS:
            ubuntu_version.values[version] = ubuntu_version.Value(version, default=version == default_ubuntu_version)

    return ubuntu_version


def setup_container(task):
    if not task.Requirements.container_resource:
        task.Requirements.container_resource = get_container_id(task.Parameters.ubuntu_version)
