# -*- coding: utf-8 -*-
import logging
from sandbox import sdk2, common

from sandbox.projects.market.frontarc.helpers.yammy.task_helpers import YammyTaskHelpersArc
from sandbox.projects.market.frontarc.helpers.arc_base import MarketFrontArcBase
from sandbox.projects.market.frontarc.helpers.ArcDefaultParameters import ArcDefaultParameters
from sandbox.projects.market.frontarc.helpers.MetatronEnvArc import ARC_TOKEN_VAULT_KEY
from sandbox.projects.market.frontarc.helpers.ArcanumApi import ArcanumApi

class YammyStatusDescriptionArc(common.utils.Enum):
    """
        Возможное описание проверки ПР
    """
    planned = "Задача запланирована"
    skipped = "Задача пропущена"
    pending = "Задача в очереди →"
    success = "Перейти к отчету →"
    error = "Задача упала →"
    failure = "Случилась ошибка →"
    test_fail = "Тесты красные →"
    stopped = "Задача прервана"
    conflict = "PR с конфликтом. Задача не выполнялась"

class YammyArcParameters(ArcDefaultParameters):
    with ArcDefaultParameters.arcanum():
        additional_refs = sdk2.parameters.List(
            "Дополнительные ref'ы которые нужно получить",
            value_type=sdk2.parameters.String,
            default=["trunk"]
        )

YAMMY_DEFAULT_SYSTEM = "YAMMY"

class YammyArcHelpers(MarketFrontArcBase):
    __head_commit = None
    __base_commit = None

    __arcanum_api = None

    @staticmethod
    def task_description(context):
        return "[YAMMY] {}".format(context)

    @property
    def arcanum_api(self):
        if not self.__arcanum_api:
            self.__arcanum_api = ArcanumApi(sdk2.Vault.data(ARC_TOKEN_VAULT_KEY))

        return self.__arcanum_api

    @property
    def head_commit(self):
        if not self.__head_commit:
            if self.Parameters.commit_hash:
                self.__head_commit = self.Parameters.commit_hash
            else:
                self.__head_commit = self.arc_rev_parse("HEAD")

        return self.__head_commit

    @property
    def base_commit(self):
        if not self.__base_commit:
            if self.Parameters.yammy_base_ref:
                self.__base_commit = self.Parameters.yammy_base_ref
            elif self.Parameters.yammy_build_meta:
                self.__base_commit = self.build_meta['baseRef']
            else:
                self.__base_commit = self.arc_merge_base(head=self.head_commit)

        return self.__base_commit

    @property
    def head_ref(self):
        if self.Parameters.pr_number:
            head_ref = "pull/{}".format(self.Parameters.pr_number)
        elif self.Parameters.head_branch:
            head_ref = self.Parameters.head_branch
        else:
            head_ref = self.head_commit

        return head_ref

    def arc_mount(self):
        super(YammyArcHelpers, self).arc_mount(store_path=self.FUSE_DIR)
        for branch in self.Parameters.additional_refs:
            self.arc_fetch(branch=branch)

    def checkout_repo(self, branch=None, commit=None, pr=None, iteration=None, published=None):
        self.arc_checkout_smart(pr=pr, commit=commit, branch=branch, iteration=iteration, published=published, default_branch_name=self.ticket)

    def package_task_context(self, package, task_name, config):
        if not self.Parameters.task_description:
            return None

        return "[{}] [{}] {}".format(
            YammyTaskHelpersArc.abbrev_package(package),
            task_name,
            config["config"]["title"]
        )

    def update_status(self, state, description, type=None, url=None):
        """
            Обновляет статус проверки для РР.
            :param type Название проверки (Аналог контекста в гитхабе)
            :param state Статус проверки
            :param description Описание проверки
            :param url Гиперссылка, для поля type
            type: (int, {system: string, type: string, enabled: boolean}, string) -> object
        """
        if not type:
            type = self.Parameters.task_description

        if not self.Parameters.pr_number or not self.Parameters.diff_set_id or not type or not state:
            return

        with self.timer("arcanum:status:{}:{}".format(state, description)):
            if url is None:
                url = common.utils.get_task_link(self.id)

            content = {
                "system": YAMMY_DEFAULT_SYSTEM,
                "type": type,
                "status": state,
                "description": description
            }

            if url:
                content['systemCheckUri']=url

            logging.debug("Setting arcanum status on {}. system='{}', type='{}' state='{}', description='{}', link='{}'".format(
                self.Parameters.pr_number, YAMMY_DEFAULT_SYSTEM, type, state, description, url
            ))

            self.arcanum_api.post_review_request_check(self.Parameters.pr_number, self.Parameters.diff_set_id, content)
