from sandbox import sdk2
import sandbox.common.types.misc as ctm
from sandbox.common.types import client as ctc

RAMDRIVE_SIZE = 16 * 1024
# RAMDRIVE_SIZE = 8 * 1024 # local sandbox


class YammySmallRequirementsArc(sdk2.Task.Requirements):
    dns = ctm.DnsType.DNS64
    client_tags = (ctc.Tag.MULTISLOT | ctc.Tag.GENERIC)
    ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, RAMDRIVE_SIZE, None)

    ram = 1 * 1024
    cores = 1
    disk_space = 16 * 1024
    # disk_space = 3 * 1024  # local sandbox

    class Caches(sdk2.Requirements.Caches):
        pass


class YammyBigRequirementsArc(sdk2.Task.Requirements):
    dns = ctm.DnsType.DNS64
    client_tags = (ctc.Tag.MULTISLOT | ctc.Tag.GENERIC)
    ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, RAMDRIVE_SIZE, None)

    ram = 32 * 1024
    cores = 16
    disk_space = 16 * 1024
    # ram = 1 * 1024  # local sandbox
    # cores = 1  # local sandbox
    # disk_space = 1 * 1024  # local sandbox

    class Caches(sdk2.Requirements.Caches):
        pass
