# -*- coding: utf-8 -*-

""" Как писать/деплоить бинарную таску:
    Немного инфы для общего понимания как это работает:
        * Этот питон запускается и как бинарь и как скрипт
        * Как скрипт он запускается при старте задачи на серверах sandbox,
          поэтому нельзя import на уровне модуля - потому что на sandbox нет аркадии
        * Далее на sandbox эта программа запускает сама себя но уже в виде бинарника
        * И только внутри бинарника доходит до on_execute, поэтому там внутри on_execute стоит импорт из аркадии
"""

from sandbox import sdk2
from sandbox.common.utils import get_task_link
from sandbox.projects.common import task_env, binary_task
from sandbox.sdk2 import yav


YT_CLUSTER_ARNOLD = 'arnold'
YT_CLUSTER_HAHN = 'hahn'
MITYPE_GIBSON = 'gibson'
MITYPE_STRAT = 'stratocaster'


class BluePromoGwpXlsParser(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """ Sandbox-скрипт для парсинга описания синих акций в виде XLS файлов """

    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)
        idx_env = sdk2.parameters.String('Indexer env: testing/production', default='testing', required=True)
        yt_table_shopdsdat = sdk2.parameters.String(
            'Shopdsdat YT table path template',
            default='//home/market/{idx_env}/indexer/{mi_type}/in/shopsdat/recent',
            required=False,
        )
        yt_path_blue_in = sdk2.parameters.String(
            'Output YT path template',
            default='//home/market/{idx_env}/indexer/{mi_type}/promos/blue/in',
            required=False,
        )
        shop_id = sdk2.parameters.String('Default shop_id', default='10264169', required=True)
        st_filter_id = sdk2.parameters.String('Startrek filter ID', default='54052', required=True)
        test_run = sdk2.parameters.Bool('Test run (do not write to YT)', default=False, required=False)
        report_proxy = sdk2.parameters.String('Report proxy for promo debug URL', default='', required=False)
        working_threads = sdk2.parameters.Integer('Max working threads', default=16, required=False)
        force_update = sdk2.parameters.Bool('Force read without cache', default=False, required=False)
        custom_params = sdk2.parameters.JSON('Custom parameters', required=False)

    def on_execute(self):
        class params(object):
            idx_env = self.Parameters.idx_env
            st_token_sec = yav.Secret('sec-01efw4gwaq632722tep9rhem23')
            yt_token_sec = yav.Secret('sec-01efw4e0830ge8s2dhyj5kkh88')

            st_token = st_token_sec.data()['st-token']
            yt_token = yt_token_sec.data()['yt-token']

            if idx_env == 'production':
                idx_insts = [
                    (YT_CLUSTER_ARNOLD, MITYPE_GIBSON),
                    (YT_CLUSTER_HAHN, MITYPE_STRAT),
                ]
            elif idx_env == 'testing':
                idx_insts = [
                    (YT_CLUSTER_ARNOLD, MITYPE_STRAT),
                ]
            else:
                raise RuntimeError('Unknown IDX_ENV {}'.format(idx_env))

            yt_table_shopdsdat = self.Parameters.yt_table_shopdsdat
            yt_path_blue_in = self.Parameters.yt_path_blue_in
            shop_id = self.Parameters.shop_id
            st_filter_id = self.Parameters.st_filter_id
            test_run = self.Parameters.test_run
            report_proxy = self.Parameters.report_proxy
            working_threads = self.Parameters.working_threads
            force_update = self.Parameters.force_update
            if not force_update and self.scheduler:
                force_update = self.scheduler < 0  # положительное - запуск по расписанию, отрицательное - ручной запуск
            custom_params = self.Parameters.custom_params
            job_url = get_task_link(sdk2.Task.current.id)

        from market.idx.promos.blue_gift_with_purchase.lib.main_task import main_task
        main_task(params)
