# -*- coding: utf-8 -*-

""" Как писать/деплоить бинарную таску:
    https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/market/idx/PrepareHroomData/__init__.py

    Немного инфы для общего понимания как это работает:
        * Этот питон запускается и как бинарь, и как скрипт
        * Как скрипт, он запускается при старте задачи на серверах sandbox,
          поэтому нельзя import на уровне модуля - потому что на sandbox нет аркадии
        * Далее на sandbox эта программа запускает сама себя, но уже в виде бинарника
        * И только внутри бинарника доходит до on_execute, поэтому там, внутри on_execute, стоит импорт из аркадии
"""

from sandbox import sdk2
from sandbox.common import utils
from sandbox.projects.common import task_env
from sandbox.projects.common.binary_task import deprecated as binary_task


YT_CLUSTER_ARNOLD = 'arnold'
YT_CLUSTER_HAHN = 'hahn'


class BluePromoLandingXlsParser(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """ Sandbox-скрипт для парсинга описания каруселей промолендингов в виде XLS файлов """

    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)
        env = sdk2.parameters.String('Environment: testing/production', default='testing', required=True)
        st_filter_id = sdk2.parameters.String('Startrek filter ID', default='67373', required=True)
        yt_output_path_template = sdk2.parameters.String(
            'Output YT path template',
            default='//home/market/{env}/indexer/promo_landing',
            required=False,
        )
        secret_id = sdk2.parameters.YavSecret("Yav secret id", required=False)
        kill_timeout = 3600 * 2

    def on_execute(self):
        class Params(object):
            st_token = sdk2.Vault.data('MARKET-IDX', 'ST_TOKEN')

            env = self.Parameters.env
            if env not in ['testing', 'production']:
                raise RuntimeError('Invalid environment: {}. Expected testing/production'.format(env))

            if env == 'production':
                yt_clusters = [YT_CLUSTER_ARNOLD, YT_CLUSTER_HAHN]
                yt_token = sdk2.Vault.data('MARKET-IDX', 'MARKET-IDX-PRODUCTION-YT-TOKEN')
                env_default_secret_id = 'sec-01efgstt6evy3yxywvjbmzj0g6'  # marketpromo_production
            elif env == 'testing':
                yt_clusters = [YT_CLUSTER_ARNOLD]
                yt_token = sdk2.Vault.data('MARKET-IDX', 'MARKET-IDX-TESTING-YT-TOKEN')
                env_default_secret_id = 'sec-01efgsprp69yrr0ekd6wq0wk28'  # marketpromo_testing
            else:
                raise RuntimeError('Unknown env {}'.format(env))

            yt_output_path = self.Parameters.yt_output_path_template.format(env=env)
            st_filter_id = self.Parameters.st_filter_id

            force_update = self.scheduler < 0  # положительное - запуск по расписанию, отрицательное - ручной запуск
            job_url = utils.get_task_link(sdk2.Task.current.id)

            cms_env = 'production'

            tvm_secret = sdk2.yav.Secret(self.Parameters.secret_id or env_default_secret_id).data()['promo.landing.tvm_secret']

        from market.idx.promos.blue_promo_landing.lib.main_task import main_task
        main_task(Params)
