# coding: utf-8

import datetime

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.common.build import YaMake2


class ExportSvnDataToYt(YaMake2.YaMake2):

    class Parameters(YaMake2.YaMake2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    def get_targets(self):
        return [
            'market/svn-data/prohibited_blue_entities',
        ]

    def get_arts(self):
        return [
            {
                'path': 'market/svn-data/prohibited_blue_entities/prohibited_blue_offers.json',
            },
        ]

    def on_execute(self):
        YaMake2.YaMake2.on_execute(self)

        filepath = './build/market/svn-data/prohibited_blue_entities/prohibited_blue_offers.json'
        tablename = datetime.datetime.now().date().strftime('%Y%m%d')
        tablepath = '//home/market/production/indexer/svn-data/prohibited_blue_offers/{}'.format(tablename)
        yt_token = sdk2.Vault.data('MARKET-IDX', 'MARKET-IDX-PRODUCTION-YT-TOKEN')

        from market.svn_data.export_to_yt.lib import export_to_yt
        export_to_yt(
            filepath=filepath,
            cluster='hahn',
            tablepath=tablepath,
            token=yt_token,
        )
