import requests

JUGGLER_API_HOST = "http://juggler-api.search.yandex.net"


class JugglerAPI:
    def __init__(self, token, env, host=JUGGLER_API_HOST):
        from juggler_sdk import JugglerApi
        self.api = JugglerApi(host, oauth_token=token) if token else None
        self.env = env

    def add_or_update(self, service, host, ttl, refresh_time=60):
        from juggler_sdk import Check
        self.api.upsert_check(
            Check(
                service=service,
                host=host,
                namespace="market.datacamp",
                refresh_time=refresh_time,
                ttl=ttl,
                aggregator="logic_or",
                aggregator_kwargs={"nodata_mode": "force_crit"},
                tags=["market_indexer_datacamp", "market_{}".format(self.env), self.env],
            )
        )

    def remove_check(self, service, host):
        reply = requests.post(
            "http://juggler-push.search.yandex.net/events",
            json={
                "source": "gen_sandbox_scheduler",
                "events": [
                    {
                        "host": host,
                        "service": service,
                        "status": "CRIT",
                        "description": "Scheduler belonging to this check was deleted. To delete this check go Edit->Delete",
                    }
                ],
            },
        )
        event_status = reply.json()["events"][0]
        if event_status["code"] != 200:
            raise Exception(event_status["error"])
