# coding: utf8

import logging
import time

from sandbox.sandboxsdk import environments
from sandbox import sdk2
from sandbox.projects.common.binary_task import deprecated as binary_task


class UploadDiscountRestrictionsToYt(sdk2.Task):
    """
    Загружает в YT таблицы из вики https://wiki.yandex-team.ru/users/evlyubimov/discounts/ с идентификаторами msku и
    hid (для категорий), для которых запрещен показ скидок
    """
    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)
        yt_token_vault_name = sdk2.parameters.String(
            'Vault name to extract YT token',
            default='MARKET-IDX-TESTING-YT-TOKEN',
            required=True)
        yt_token_vault_owner = sdk2.parameters.String(
            'Vault owner to extract YT token',
            default='MARKET',
            required=True)
        wiki_oauth_token_vault_name = sdk2.parameters.String(
            'Vault name to extract wiki oauth token',
            default='OAUTH_TOKEN',
            required=True)
        wiki_oauth_token_vault_owner = sdk2.parameters.String(
            'Vault owner to extract wiki oauth token',
            default='MARKET-IDX',
            required=True)

        yt_cluster = sdk2.parameters.String(
            'YT cluster',
            default='arnold',
            required=True)
        yt_environment = sdk2.parameters.String(
            'YT environment',
            default='testing',
            required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        )

    def on_execute(self):
        import yt.wrapper as yt
        from market.idx.pylibrary.wiki_uploader.yt_uploader import (
            MskuDiscountRestrictionsUploader,
            CategoryDiscountRestrictionsUploader,
            PriceHistoryLimitUploader
        )

        logging.info('Started UploadDiscountRestrictionsToYt')

        yt_token = sdk2.Vault.data(self.Parameters.yt_token_vault_owner,
                                   self.Parameters.yt_token_vault_name)
        wiki_token = sdk2.Vault.data(self.Parameters.wiki_oauth_token_vault_owner,
                                     self.Parameters.wiki_oauth_token_vault_name)

        yt_client = yt.YtClient(proxy=self.Parameters.yt_cluster, token=yt_token)
        generation = time.strftime('%Y%m%d_%H%M')

        uploaders = [
            MskuDiscountRestrictionsUploader(
                yt_client,
                self.Parameters.yt_cluster,
                self.Parameters.yt_environment,
                wiki_token
            ),
            CategoryDiscountRestrictionsUploader(
                yt_client,
                self.Parameters.yt_cluster,
                self.Parameters.yt_environment,
                wiki_token
            ),
            PriceHistoryLimitUploader(
                yt_client,
                self.Parameters.yt_cluster,
                self.Parameters.yt_environment,
                wiki_token
            )
        ]

        for uploader in uploaders:
            logging.info('Upload discount restrictions: {}'.format(uploader.__class__.__name__))
            result = uploader.upload(generation)
            self.set_info(result, do_escape=False)
            logging.info('Upload complete')

        logging.info('Exiting task')
