from sandbox.sdk2 import (
    Resource,
    parameters
)


class IdxDebResource(Resource):
    '''
        deb files of market indexer
    '''
    package_version = parameters.String('version')
    revision = parameters.String('revsion')
    any_arch = False
    executable = False
    auto_backup = True
    ttl = 30


class IdxChangelogFileResource(Resource):
    '''
        changelog file of market indexer
    '''
    module_path = parameters.String('module path')
    module_version = parameters.String('release version')


class IdxTsumJsonResource(Resource):
    '''
        json for tsum (market indexer)
    '''
    share = True
