import logging
import os
import re
import tarfile

from sandbox import sdk2
from sandbox.projects.common.vcs.arc import Arc
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.ya_deploy import release_integration

class MARKET_EXP3_MATCHER_APP(sdk2.Resource):
        """Market sidecar exp3 matcher resource"""

        releasable = True


class MarketExp3MatcherApp(release_integration.ReleaseToNannyAndYaDeployTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        config_path = sdk2.parameters.ArcadiaUrl(
            "Path for taxi config recipe.ext",
            default_value="./arcadia/taxi/uservices/services/exp3-matcher/recipes/binary/recipe.ext",
            required=False
        )
        arc_token_vault = sdk2.parameters.Vault("Vault secret contains ARC_TOKEN", default_value="MARKET:ARC_TOKEN", required=False)

    #def on_release(self, additional_parameters):
    #    nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
    #    sdk2.Task.on_release(self, additional_parameters)
        
    def repack_tar_file(self, old_resource_file, new_resource_file):
        oldtar = tarfile.open(old_resource_file, 'r')
        with tarfile.open(new_resource_file, "w:gz") as newtar:
            logging.info("Files(old archive) {} is file {}".format(oldtar.getmembers(), old_resource_file))
            for new_dir in ["conf/exp3-matcher", "bin"]:
                new_tar_dir = tarfile.TarInfo(new_dir)
                new_tar_dir.type = tarfile.DIRTYPE
                new_tar_dir.mode = 0755
                newtar.addfile(new_tar_dir)
            for member in oldtar.getmembers():
                if member.isfile():
                    name = os.path.basename(member.name)
                    if name.endswith(".yaml") or name.endswith(".json"):
                        member.name = os.path.join("conf/exp3-matcher", name)
                    else:
                        member.name = os.path.join("bin", name)
                    logging.info("Add file {} to new resource archive {}".format(member.name, new_resource_file))
                    f = oldtar.extractfile(member)
                    newtar.addfile(member, fileobj=f.fileobj)
                logging.info("Files(new archive) {} is file {}".format(newtar.getmembers(), new_resource_file))

    def on_execute(self):
        logging.info("Start prepare resource exp3 matcher application")
        arc = Arc(arc_oauth_token=self.Parameters.arc_token_vault.data())
        logging.debug("OAuth token {}".format(self.Parameters.arc_token_vault.data()))
        rgxp = re.compile("IF\\(OS_LINUX\\)\s+FROM_SANDBOX\\(\s+.*\s+(\d+)\s+.*")
        with arc.mount_path(None, "trunk", mount_point="./arcadia", fetch_all=False) as mp:
            arc.checkout(mp)
            logging.debug("Mount point path: {}".format(mp))
            logging.debug("Read exp3 matcher application archive {}".format(self.Parameters.config_path))
            with open(self.Parameters.config_path, "r") as fp:
                config = fp.read()
                try:
                    resource_id = rgxp.search(config).groups()[0]
                except Exception as err:
                    raise ValueError("Not found sandbox resource id: {}, error: {}".format(config, err))
            logging.info("Start download resource {}".format(resource_id))
            # resource_id = 119 # for debug
            resource = sdk2.Resource[resource_id]
            data = sdk2.ResourceData(resource)
            oldpath = "{}".format(data.path)
            logging.info("Resource {} downloaded to {}".format(resource_id, oldpath))
            newpath = os.path.join(os.getcwd(), "resource_new.tar.gz")
            # newpath = "/tmp/resource_new.tar.gz" # for debug
            self.repack_tar_file(oldpath, newpath)
            logging.info("Old resource: {}, new resource: {}".format(oldpath, newpath))
            new_resource = MARKET_EXP3_MATCHER_APP(self, "Resource exp3 matcher application", "resource.tar.gz")
            with open(newpath, 'r') as fd:
                new_resource.path.write_bytes(fd.read())
