#!/usr/bin/env bash

# Если ты нашёл этот скрипт в Аркадии:
# Чтобы собрать новый образ для Sandbox-таски MARKET_HEALTH_INTEGRATION_TESTS нужно запустить таску SANDBOX_LXC_IMAGE с
# галочкой "Create custom LXC image" и этим скриптом в поле "Shell script to execute during final stage".

# Если ты нашёл этот скрипт в параметрах прошлых запусков SANDBOX_LXC_IMAGE:
# Этот скрипт живёт в Аркадии:
# https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/market/infra/MarketHealthIntegrationTests.
# Пожалуйста коммить все изменения туда.

set -euxo pipefail

# Добавляем репозиторий и ключи для него.
# Команды взяты отсюда: https://docs.docker.com/install/linux/docker-ce/ubuntu/#install-using-the-repository
curl -fsSL 'https://download.docker.com/linux/ubuntu/gpg' | apt-key add -
printf "deb [arch=amd64] https://download.docker.com/linux/ubuntu %s stable" "$(lsb_release -cs)" > /etc/apt/sources.list.d/docker.list

# Ставим Docker и Java.
# unbound-config-local64 - пакет, который настраивает сеть так, чтобы можно было ходить на IPv4-only хосты по IPv6.
apt-get update
DEBIAN_FRONTEND=noninteractive \
  apt-get install -y \
  'docker-ce=5:18.09*' \
  'docker-ce-cli=5:18.09*' \
  yandex-jdk8 \
  unbound-config-local64

# Ставим Docker Compose
# https://docs.docker.com/compose/install/
curl -fsSL "https://github.com/docker/compose/releases/download/1.24.1/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose
chmod +x /usr/local/bin/docker-compose
