from sandbox.sdk2 import (
    Resource,
    parameters
)


class TsumJsonResource(Resource):
    '''
        json for tsum (market indexer)
    '''
    share = True


class UnstripBinary(Resource):
    '''
        exec binaries of market indexer
    '''
    package_version = parameters.String('version')
    binary_path = parameters.String('path')
    binary_name = parameters.String('name')
    revision = parameters.String('revsion')
    any_arch = False
    executable = True
    auto_backup = True
    ttl = 30


class TsumHotfixScript(Resource):
    pass


class BuildLog(Resource):
    """Package build output for Market Indexer packages.
    Intended for audit, thus the big TTL
    """
    package_version = parameters.String('version')
    revision = parameters.String('revision')
    any_arch = True
    auto_backup = True
