# coding=utf-8
import logging
import os

from sandbox.sdk2.vcs.svn import Arcadia


def checkout_immediates(path, arcadia_dir_path):
    arcadia_dir = Arcadia.checkout(
        'arcadia:/arc/trunk/arcadia', path=path, depth='immediates'
    )
    logging.info("Arcadia checkouted to %s", arcadia_dir)
    return update_local_path(arcadia_dir, arcadia_dir_path)


def update_local_path(arcadia_checkout_dir, update_path):
    dest_arcadia_dir = arcadia_checkout_dir

    for dir_part in update_path.split('/'):
        dest_arcadia_dir = os.path.join(dest_arcadia_dir, dir_part)
        logging.info("Update immediates at %s", dest_arcadia_dir)
        if not os.path.exists(dest_arcadia_dir):
            break
        Arcadia.update(dest_arcadia_dir, set_depth='immediates')

    return arcadia_checkout_dir


def safe_add_files(arcadia_dir):
    # Svn очень нежный, если например сделать add на директорию,
    # а потом на файл в этой директории - будет ошибка, что файл уже добавлен.
    added = True
    while added:
        added = False
        status = Arcadia.status(arcadia_dir)
        logging.info("Svn status: \n%s", status)
        for status_line in status.splitlines():
            if status_line.startswith('?'):
                path = status_line[1:].strip()
                logging.info("Adding svn path: %s", path)
                Arcadia.add(path)
                added = True
                continue
