# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common import constants as consts

_TARGET_RESOURCE_TYPES = [
    resource_types.MARKET_GURU_ASSISTANT_PRINTGURUASS,
    resource_types.MARKET_MBO_PARAMSDUMP,
]


def _init_resources(task):
    for resource_type in _TARGET_RESOURCE_TYPES:
        resource = task.create_resource(
            description=resource_type.name,
            resource_type=resource_type,
            resource_path=resource_type.name,
        )
        task.ctx[resource_type.name] = resource.id


def _get_input_parameters(task):
    params = _TARGET_RESOURCE_TYPES
    return {
        key: value for param in params
        for key, value in task.ctx.iteritems()
        if key == param.name
    }


def _build_binaries(task):
    from projects.common import utils

    input_parameters = _get_input_parameters(task)
    input_parameters['notify_if_finished'] = ''
    input_parameters[consts.ARCADIA_URL_KEY] = task.ctx[consts.ARCADIA_URL_KEY]

    if 'build_tasks_id' not in task.ctx:
        build_binaries_task_id = task.create_subtask(
            task_type='BUILD_MARKET_GURU_ASSISTANT_EXECUTABLE',
            description=task.description,
            input_parameters=input_parameters,
        )

        task.ctx['build_tasks_id'] = [build_binaries_task_id.id]

        utils.wait_all_subtasks_stop()
    elif utils.check_all_subtasks_done():
        pass
    else:
        utils.restart_broken_subtasks()


def get_resource_by_type(task, res_type, ctx_key):
    res_id = task.ctx[res_type.name]
    res_path = task.sync_resource(res_id)
    task.ctx[ctx_key] = res_path
    return res_path


def build_binaries(task):
    _init_resources(task)
    _build_binaries(task)
    get_resource_by_type(task, resource_types.MARKET_GURU_ASSISTANT_PRINTGURUASS, 'cfg_programm_printguruass')
    get_resource_by_type(task, resource_types.MARKET_MBO_PARAMSDUMP, 'cfg_programm_paramsdump')
