from sandbox.projects import resource_types
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


def get_newest_resource_id(resource_type, attrs=None):
    res = channel.sandbox.list_resources(
        resource_type=resource_type,
        status='READY',
        hidden=False,
        limit=1,
        all_attrs=attrs
    )
    if res:
        return res[0].id
    return None


def get_newest_resource(task, resource_type, name, attrs=None):
    res_id = get_newest_resource_id(resource_type, attrs)
    if not res_id:
        raise SandboxTaskFailureError("Can't find " + name)
    return task.sync_resource(res_id)


def get_last_release(task):
    from projects.common import constants as consts
    import projects.common.build.arcadia_project_misc as misc

    res_id = get_newest_resource_id(resource_types.MARKET_GURU_ASSISTANT_BIN, {'released': 'stable'})
    if not res_id:
        res_id = get_newest_resource_id(resource_types.MARKET_GURU_ASSISTANT_BIN)
    if not res_id:
        raise SandboxTaskFailureError("Can't find guruassistant release")
    task.ctx['cfg_guruassistant_id'] = res_id
    arc_path = misc.get_arcadia_project_svn_url(res_id)
    task.ctx[consts.ARCADIA_URL_KEY] = arc_path
    return arc_path


def _filtr_bin_attrs(attrs):
    attr_list = ('arcadia_branch', 'arcadia_revision', 'arcadia_tag', 'arcadia_trunk')
    return {key: attrs[key] for key in attr_list if key in attrs}


def get_bin_by_type(task, res_type, ctx_key):
    import platform

    attrs = _filtr_bin_attrs(channel.sandbox.get_resource(task.ctx['cfg_guruassistant_id']).attributes)
    attrs['build_platform'] = platform.platform()

    res_id = get_newest_resource_id(res_type, attrs)
    if not res_id:
        return None
    res_path = task.sync_resource(res_id)
    task.ctx[ctx_key] = res_path
    return res_path


def copy_and_release(task, filename, description, resource_type, attributes):
    from os import path
    from sandbox.sandboxsdk.process import run_process

    result_file_name = path.basename(filename)
    cmd = 'cp {} {}'.format(filename, result_file_name)
    run_process(cmd, check=True, wait=True, log_prefix='copy_and_release')

    result_resource = task.create_resource(
        description=description,
        resource_path=result_file_name,
        resource_type=resource_type,
        attributes=attributes
    )
    task.mark_resource_ready(result_resource.id)

    return result_resource
