# -*- coding: utf-8 -*-

import os

import sandbox.common.types.client as ctc

import sandbox.projects.common.build.parameters as build_params
from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.channel import channel


class BuildMarketGuruAssistantExecutable(nanny.ReleaseToNannyTask, YaMakeTask):
    type = 'BUILD_MARKET_GURU_ASSISTANT_EXECUTABLE'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.Sanitize,
    ]
    TARGET_RESOURCE_TYPES = [
        resource_types.MARKET_GURU_ASSISTANT_PRINTGURUASS,
        resource_types.MARKET_MBO_PARAMSDUMP,
        resource_types.MARKET_GURU_ASSISTANT_BIN,
    ]

    execution_space = 50 * 1024  # 50 Gb. We may have to checkout arcadia
    cores = 24
    client_tags = ctc.Tag.Group.LINUX

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources

    def get_targets(self):
        return [
            resource_type.arcadia_build_path for resource_type in self.TARGET_RESOURCE_TYPES
            ]

    def get_arts(self):
        return [
            {'path': resource_type.arcadia_build_path} for resource_type in self.TARGET_RESOURCE_TYPES
            ]

    def post_build(self, source_dir, output_dir, pack_dir):
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resources = channel.sandbox.list_resources(resource_type=resource_type, task_id=self.id)
            for resource in resources:
                # Проверям передавал ли родительский таск id ресурса, который нужно заполнить
                if self.ctx.get(resource_type.name):
                    self.save_parent_task_resource(resource.path, self.ctx[resource_type.name])


__Task__ = BuildMarketGuruAssistantExecutable
