# coding: utf-8


from sandbox.projects import resource_types
from sandbox.projects.market.kgb.MarketCatalogerShooter2 import MarketCatalogerShooter2, GraphiteHost
from sandbox.projects.common.search import performance as search_performance

from sandbox.sandboxsdk.parameters import ResourceSelector


class BukerBin(ResourceSelector):
    name = 'buker_bin'
    description = 'Buker binary. Empty to build from trunk'
    resource_type = resource_types.MARKET_BUKER_BIN_ONLINE
    required = False


class BukerData(ResourceSelector):
    name = 'buker_data'
    description = 'Buker data. Empty to auto-find'
    resource_type = resource_types.MARKET_BUKER_DATA
    required = False


class BukerRequests(ResourceSelector):
    name = 'buker_requests'
    description = 'Buker requests'
    resource_type = resource_types.PLAIN_TEXT_QUERIES
    default_value = 190921798  # grepped from logs
    required = True


class MarketBukerShooter2(MarketCatalogerShooter2):
    """
        Таск приемки букера на производительность
    """
    type = 'MARKET_BUKER_SHOOTER2'

    input_parameters = (
        BukerBin,
        BukerData,
        BukerRequests,
        GraphiteHost,
    ) + search_performance.OldShootingTask.shoot_input_parameters

    binary_type = resource_types.MARKET_BUKER_BIN_ONLINE
    binary_ctx_name = BukerBin.name
    data_type = resource_types.MARKET_BUKER_DATA
    plan_type = resource_types.MARKET_BUKER_PLAN
    data_ctx_name = BukerData.name
    binary_build_task_type = 'BUILD_MARKET_BUKER_BIN'
    daemon_name = 'buker'
    reqs_ctx_name = BukerRequests.name

    @staticmethod
    def generate_config(data_path, port):
        tpl = """
DATA_PATH                   {data}
MODELS_DATA_FILENAME        hyper_id_data.csv
CARDS_DATA_FILENAME         big_guru_card.data
CARDS_INDEX_FILENAME        big_guru_card.index.csv
MICRO_CARDS_DATA_FILENAME   small_guru_card.data
MICRO_CARDS_INDEX_FILENAME  small_guru_card.index.csv
COLLECTIONS_DIR {data}

HTTP_PORT                        {port}
LOG                              daemon.log
PIDFILE_DIR                      .
"""
        return tpl.format(data=data_path, port=port)


__Task__ = MarketBukerShooter2
