def get_flow_to_path_for_fulfillment(string_mapping):
    return get_flow_to_path('fulfillment', string_mapping)


def get_flow_to_path_for_delivery(string_mapping):
    return get_flow_to_path('delivery', string_mapping)


def get_flow_to_path(type, string_mapping):
    result = {}
    parts = string_mapping.split(';')
    for part in parts:
        trimmed_part = part[1:-1].strip()
        key_and_value = trimmed_part.split(',')
        trimmed_key = key_and_value[0].strip()
        trimmed_value = key_and_value[1].strip()
        path = '/task/' + type + '/' + trimmed_value
        result[trimmed_key] = path
    return result
