# coding=utf-8
# util method for generating ammo

import json
from xml.etree.ElementTree import ElementTree, fromstring, tostring


def make_ammo(method, url, tag, headers, body, fulfillment_token, delivery_token, fulfillment_id, delivery_id):
    """
        Makes phantom ammo
        http://yandextank.readthedocs.org/en/latest/ammo_generators.html
    """

    is_json_request = url != '/fulfillment/query-gateway' and url != '/delivery/query-gateway'
    req_with_headers = "%s %s HTTP/1.1\r\n"
    body_length = 0
    if body:
        if is_json_request:
            body_with_correct_partner = modify_partner_in_body(url, body, fulfillment_id, delivery_id)
        else:
            body_with_correct_partner = modify_token_in_body(body, url, fulfillment_token, delivery_token)
        body_length = len(body_with_correct_partner)
    parsed_headers = parse_headers(headers, is_json_request, body_length)
    for header in parsed_headers:
        req_with_headers = req_with_headers + header + "\r\n"
    # http request without body template
    req_template_without_body = req_with_headers + "\r\n"

    # http request with body template
    req_template_with_body = req_with_headers + "\r\n" + "%s\r\n\r\n"

    if not body:
        req = req_template_without_body % (method, url)
    else:
        req = req_template_with_body % (method, url, body_with_correct_partner)

    # phantom ammo template
    ammo_template = (
        "%d %s\n"
        "%s\n"
    )

    return ammo_template % (len(req.encode('utf-8')), tag, req)


def is_delivery_path(url):
    return url.startswith('/delivery') or url.startswith('/task/delivery')


def modify_partner_in_body(url, body, fulfillment_id, delivery_id):
    try:
        json_object = json.loads(body)
        partner = json_object.get("partner")
        if not partner:
            return body

        partner_id = partner.get("id")
        if not partner_id:
            return body

        if is_delivery_path(url):
            json_object["partner"]["id"] = delivery_id
        else:
            json_object["partner"]["id"] = fulfillment_id
        return json.dumps(json_object)
    except ValueError:
        return body


def modify_token_in_body(body, url, fulfillment_token, delivery_token):
    if is_delivery_path(url):
        correct_token = delivery_token
    else:
        correct_token = fulfillment_token
    parsed_xml = ElementTree(fromstring(body))
    token = parsed_xml.findall('token')[0]
    token.text = correct_token
    return tostring(parsed_xml.getroot(), encoding='utf-8').decode('utf-8')


def parse_headers(headers, is_json, body_length):
    headers_list = []
    key = ""
    inside_quotes = False
    current_key_value_start_index = 0
    current_key_start_index = 0
    current_index = 0
    has_content_type_header = False
    for symbol in headers:
        if symbol == ':' and len(key) == 0:
            key = headers[current_key_value_start_index:current_index]
            current_key_start_index = current_index + 1
        if symbol == '"':
            inside_quotes = not inside_quotes
        if symbol == ',' and not inside_quotes:
            stripped_key = key.strip()
            reformat_header(headers, current_key_start_index, current_index, stripped_key, headers_list)
            current_key_value_start_index = current_index + 1
            if stripped_key.lower() == 'content-type':
                has_content_type_header = True
            key = ""
        current_index = current_index + 1
    stripped_key = key.strip()
    reformat_header(headers, current_key_start_index, current_index, stripped_key, headers_list)
    headers_list.append('Content-Length: ' + str(body_length))
    if stripped_key.lower() == 'content-type':
        has_content_type_header = True
    if not has_content_type_header:
        if is_json:
            headers_list.append('Content-Type: application/json')
        else:
            headers_list.append('Content-Type: text/xml')
    return headers_list


def reformat_header(headers, current_key_start_index, current_index, key, headers_list):
    value = headers[current_key_start_index:current_index]
    if key.lower() != 'content-length':
        headers_list.append(key + ': ' + value.strip().replace('"', '').replace(' ', ''))

