# coding=utf-8
# util method for preparing mock which will be used by LGW during shooting

import xml.etree.ElementTree as ET
from json import loads
from requests_customizer import make_custom_modification_for_sync_request_and_response, customize_push_stocks_request, \
    customize_push_orders_statuses_changed_request

import requests


class Parameters:
    CALL_NUMBER = 0


def prepare_mock(path, request_body, response_body, mock_base_url, custom_mock_path, mock_delivery_partner_id, mock_fulfillment_partner_id):
    mock_url = create_context_mock_url(path, mock_base_url, custom_mock_path)
    content_type_header = {'Content-Type': 'application/xml'}
    current_call_number = Parameters.CALL_NUMBER
    Parameters.CALL_NUMBER += 1
    if path != '/fulfillment/query-gateway' and path != '/delivery/query-gateway':
        request_body_json = loads(request_body)
        request_body_json.pop('partner', None)
        request_xml = json_to_xml_wrapped(request_body_json, 'request')
        if response_body is not None and len(response_body) > 0:
            response_xml = json_to_xml_wrapped(loads(response_body), 'response')
        else:
            response_xml = None
        modified_request_xml = modify_request_or_response_xml_for_json(request_xml, path)
        if response_xml is None:
            modified_response_xml = '<root>No body</root>'
        else:
            modified_response_xml = wrap_response_body(modify_request_or_response_xml_for_json(response_xml, path))
        request_and_response = make_custom_modification_for_sync_request_and_response(modified_request_xml, modified_response_xml, path)
        item_for_post = create_item_for_post(request_and_response[0], request_and_response[1], 'xml')
    else:
        request_json = create_json_from_xml_for_query_gateway_request(path, request_body, mock_delivery_partner_id,
                                                                      mock_fulfillment_partner_id).replace('\'', '"')
        response_json = '{}'
        item_for_post = create_item_for_post(request_json, response_json, 'json')
        request_and_response = (request_json, response_json)
    requests.post(mock_url, data=item_for_post, headers=content_type_header)
    return str(current_call_number) + '. ' + path + '\n' + request_and_response[0] + '\n\n' + request_and_response[1] + '\n\n'


def create_context_path_from_incoming_path(path):
    path_to_transform = path[1:]  # removing leading /
    return 'stress-' + path_to_transform.replace('/', '-')


def create_context_mock_url(path, mock_base_url, custom_mock_path):
    if custom_mock_path is not None:
        return mock_base_url + '/' + custom_mock_path + '/mock'
    else:
        return mock_base_url + '/' + create_context_path_from_incoming_path(path) + '/mock'


def create_item_for_post(request_body, response_body, content_type):
    root = ET.Element('root')
    disposable = ET.SubElement(root, "disposable")
    disposable.text = 'false'
    in_element = ET.SubElement(root, "in")
    in_element.text = request_body
    out = ET.SubElement(root, "out")
    out.text = response_body
    content_type_element = ET.SubElement(root, "contentType")
    content_type_element.text = content_type
    contains_content_patterns = ET.SubElement(root, "containsContentPatterns")
    contains_content_patterns.text = 'false'
    return ET.tostring(root, encoding='utf-8')


def modify_request_or_response_xml_for_json(xml, path):
    tree = ET.fromstring(xml)
    splited = path.rsplit('/', 1)
    tree.attrib['type'] = splited[len(splited) - 1]
    return ET.tostring(tree, encoding='utf-8').decode('utf-8')


def create_json_from_xml_for_query_gateway_request(path, xml, mock_delivery_partner_id, mock_fulfillment_partner_id):
    tree = ET.fromstring(xml)
    request_name = tree.find('request').attrib['type']
    request = tree.find('request')
    if path == '/delivery/query-gateway':
        if request_name == 'pushOrdersStatusesChanged':
            return customize_push_orders_statuses_changed_request(request, mock_delivery_partner_id)
    else:
        if request_name == 'pushStocks':
            return customize_push_stocks_request(request, mock_fulfillment_partner_id)
        elif request_name == 'pushOrdersStatusesChanged':
            return customize_push_orders_statuses_changed_request(request, mock_fulfillment_partner_id)


def wrap_response_body(xml):
    root = ET.Element('root')
    response = ET.fromstring(xml)
    hash_element = ET.SubElement(root, 'hash')
    hash_element.text = '${hash}'
    uniq_element = ET.SubElement(root, 'uniq')
    uniq_element.text = '${uniq}'
    request_state_element = ET.SubElement(root, 'requestState')
    is_error_element = ET.SubElement(request_state_element, 'isError')
    is_error_element.text = 'false'
    root.append(response)
    return ET.tostring(root, encoding='utf-8').decode('utf-8')


def json_to_xml_wrapped(json_obj, wrap_tag):
    result_list = list()
    result_list.append('<%s>' % wrap_tag)
    result_list.append(json_to_xml(json_to_xml(json_obj)))
    result_list.append('</%s>' % wrap_tag)
    return ''.join(result_list)


def json_to_xml(json_obj, parent_tag=None):
    result_list = list()
    json_obj_type = type(json_obj)

    if json_obj_type is list:
        for sub_elem in json_obj:
            if parent_tag is not None:
                new_tag = get_xml_list_element_tag(parent_tag)
                if sub_elem is not None:
                    result_list.append('<%s>' % new_tag)
                    result_list.append(json_to_xml(sub_elem))
                    result_list.append('</%s>' % new_tag)
            else:
                if sub_elem is not None:
                    result_list.append(json_to_xml(sub_elem))
        return ''.join(result_list)
    if json_obj_type is dict:
        for tag_name in json_obj:
            sub_obj = json_obj[tag_name]
            if sub_obj is not None:
                result_list.append('<%s>' % tag_name)
                result_list.append(json_to_xml(sub_obj, tag_name))
                result_list.append('</%s>' % tag_name)
        return ''.join(result_list)
    return '%s' % json_obj


def get_xml_list_element_tag(parent_tag):
    if not parent_tag.lower().endswith('status') and parent_tag.endswith('s'):
        return parent_tag[:-1]
    elif parent_tag.endswith('List'):
        return parent_tag[:-4]
    else:
        last_s_before_upper_index = -1
        for i, character in enumerate(parent_tag):
            if character.isupper():
                if i != 0 and parent_tag[i - 1] == 's':
                    last_s_before_upper_index = i - 1
                else:
                    last_s_before_upper_index = -1
        if last_s_before_upper_index == -1:
            return parent_tag + 'Item'
        else:
            return parent_tag[0:last_s_before_upper_index] + parent_tag[last_s_before_upper_index + 1:]


