import xml.etree.ElementTree as ET

PUSH_ORDERS_STATUSES_CHANGED_RENAMING = {'yandexId': 'orderId', 'deliveryId': 'trackCode', 'fulfillmentId': 'trackCode',
                                         'partnerId': 'trackCode'}


def make_custom_modification_for_sync_request_and_response(request, response, path):
    request_xml = ET.fromstring(request)
    response_xml = ET.fromstring(response)
    if path == '/fulfillment/getInboundHistory':
        inbound = request_xml.find('inbound')
        if inbound is not None:
            inbound.tag = 'inboundId'
        inbound_status_history = response_xml.find('response').find('inboundStatusHistory')
        inbound_id = inbound_status_history.find('inboundId')
        for history_item in inbound_status_history.find('history').findall('historyItem'):
            history_item.tag = 'inboundStatus'
            status_code = history_item.find('statusCode')
            status_code.text = status_code_to_inbound_status_code(status_code.text)
            insert_sub_element(ET.SubElement(history_item, 'inboundId'), inbound_id)
    if path == '/fulfillment/getInboundsStatus':
        inbounds_status = response_xml.find('response').find('inboundsStatus')
        for inbound_status in inbounds_status.findall('inboundStatus'):
            status_code = ET.SubElement(inbound_status, 'statusCode')
            lgw_status = inbound_status.find('status')
            status_code.text = status_code_to_inbound_status_code(lgw_status.find('statusCode').text)
            date = ET.SubElement(inbound_status, 'date')
            date.text = lgw_status.find('date').text
            for child_element in inbound_status:
                if child_element.tag == 'status':
                    inbound_status.remove(child_element)
    if path == '/fulfillment/getOutboundHistory':
        outbound_status_history = response_xml.find('response').find('outboundStatusHistory')
        for history_item in outbound_status_history.find('history').findall('historyItem'):
            history_item.tag = 'outboundStatus'
    if path == '/fulfillment/getOrderHistory':
        order_status_history = response_xml.find('response').find('orderStatusHistory')
        for history_item in order_status_history.find('history').findall('historyItem'):
            history_item.tag = 'orderStatus'
    if path == '/fulfillment/getOrdersStatus':
        order_status_histories = response_xml.find('response').find('orderStatusHistories')
        for order_status_history in order_status_histories.findall('orderStatusHistorie'):
            order_status_history.tag = 'orderStatusHistory'
            history = order_status_history.find('history')
            for history_item in history.findall('historyItem'):
                history_item.tag = 'orderStatus'
    if path == '/fulfillment/getTransferHistory':
        history = response_xml.find('response').find('transferStatusHistory').find('history')
        for history_item in history.findall('historyItem'):
            history_item.tag = 'transferStatusEvent'
    if path == '/delivery/getReferencePickupPoints':
        search_by_locations = request_xml.find('searchByLocations')
        search_by_codes = request_xml.find('searchByCodes')
        if search_by_locations is not None:
            for search_by_location in search_by_locations.findall('searchByLocation'):
                search_by_location.tag = 'location'
        if search_by_codes is not None:
            for search_by_code in search_by_codes:
                search_by_code.tag = 'code'
        pickup_points = response_xml.find('response').find('pickupPoints')
        if pickup_points is not None:
            for pickup_point in pickup_points.findall('pickupPoint'):
                schedule = pickup_point.find('schedule')
                if schedule is not None:
                    for schedule_item in schedule.findall('scheduleItem'):
                        schedule_item.tag = 'workTime'
                calendar = pickup_points.find('calendar')
                if calendar is not None:
                    for calendar_item in calendar.findall('calendarItem'):
                        calendar_item.tag = 'dateBool'
    if path == '/delivery/getOrderHistory':
        order_status_history = response_xml.find('response').find('orderStatusHistory')
        for history_item in order_status_history.find('history').findall('historyItem'):
            customize_delivery_order_status(history_item)
    if path == '/delivery/getOrdersStatus':
        order_status_histories = response_xml.find('response').find('orderStatusHistories')
        for order_status_history in order_status_histories.findall('orderStatusHistorie'):
            order_status_history.tag = 'orderStatusHistory'
            history = order_status_history.find('history')
            for history_item in history.findall('historyItem'):
                customize_delivery_order_status(history_item)
    if path == '/delivery/getOrdersDeliveryDate':
        order_delivery_dates = response_xml.find('response').find('orderDeliveryDates')
        order_delivery_dates.tag = 'ordersDeliveryDate'
    if path == '/delivery/getReferenceWarehouses':
        warehouses = response_xml.find('response').find('warehouses')
        for warehouse in warehouses.findall('warehouse'):
            customize_delivery_warehouse(warehouse)
    return ET.tostring(request_xml, encoding='utf-8').decode('utf-8'), ET.tostring(response_xml, encoding='utf-8').decode('utf-8')


def customize_push_stocks_request(tree, partner_id):
    json_body = {}
    source_body = {'warehouseId': partner_id}
    json_body['source'] = source_body
    item_stocks_list_element = tree.find('itemStocksList')
    if item_stocks_list_element is None:
        return str(json_body)
    item_stocks_list_json = xml_to_json(item_stocks_list_element, ['stocks'], True,
                                        ['vendorId', 'type', 'count'], {})
    json_body['itemStocks'] = item_stocks_list_json
    return str(json_body)


def customize_push_orders_statuses_changed_request(tree, partner_id):
    json_body = {}
    json_partners = [{'id': partner_id}]
    json_body['partners'] = json_partners
    item_orders_ids = tree.find('ordersIds')
    if item_orders_ids is None:
        return str(json_body)
    item_orders_ids_json = xml_to_json(item_orders_ids, [], True, [], PUSH_ORDERS_STATUSES_CHANGED_RENAMING)
    json_body['ordersId'] = item_orders_ids_json
    return str(json_body)


def xml_to_json(tree, list_tags, children_of_list, number_tags, renamings):
    current_tag = tree.tag
    if len(tree) == 0:
        current_node_value = tree.text
        if current_node_value is None:
            return None
        if current_tag in number_tags:
            current_node_value = int(current_node_value)
        return current_node_value
    else:
        if children_of_list:
            result_json = []
        else:
            result_json = {}
        for children in tree:
            children_json = xml_to_json(children, list_tags, children.tag in list_tags, number_tags, renamings)
            if children_json is None:
                continue
            if children_of_list:
                result_json.append(children_json)
            else:
                result_json[get_customized_tag(children.tag, renamings)] = children_json
        return result_json


def get_customized_tag(tag, renamings):
    if tag in renamings:
        return renamings[tag]
    else:
        return tag


def customize_delivery_order_status(history_item):
    history_item.tag = 'orderStatus'
    warehouse = history_item.find('warehouse')
    customize_delivery_warehouse(warehouse)


def customize_delivery_warehouse(warehouse):
    if warehouse is not None:
        schedule = warehouse.find('schedule')
        for schedule_item in schedule.findall('scheduleItem'):
            schedule_item.tag = 'workTime'


def status_code_to_inbound_status_code(status_code):
    if status_code == '3':
        return '0'
    elif status_code == '220':
        return '20'
    elif status_code == '230':
        return '30'
    elif status_code == '240':
        return '40'
    else:
        return status_code


def insert_sub_element(element, sub_element):
    element.text = sub_element.text
    for child in sub_element:
        new_sub_element = ET.SubElement(element, child.tag)
        insert_sub_element(new_sub_element, child)
