# -*- coding: utf-8 -*-
from __future__ import unicode_literals

def main():
    from sandbox.projects.market.mcrp.MarketMcrpAbcSync.abc import Dispenser, Resource, RequestValueError, MDBCloud,\
        DC, YTCluster, LogBrokerCluster, DistBuildSegment, SandboxSegment
    import json
    client = Dispenser()
    res = client.get_dictionaries()
    sb = []
    # segmentations
    print('Resources: ')
    for provider in res['providers']:
        if provider['key'] == 'sandbox':
            sb = provider['resources']
        for resource in provider['resources']:
            try:
                Resource.from_str(resource['key'])
            except RequestValueError:
                print('{}: {} - {}'.format(provider['name'], resource['key'], resource['name']))
            # print(json.dumps(provider['resources'], indent=2))
    print('Locations: ')
    # print(json.dumps(res['segmentations'], indent=2))
    for cloud in res['segmentations']:
        for segment in cloud['segments']:
            try:
                if cloud['key'] == 'locations':
                    DC.from_str(segment['key'])
                elif cloud['key'] == 'yt_cluster':
                    YTCluster.from_str(segment['key'])
                elif cloud['key'] == 'dbaas_db':
                    MDBCloud.from_str(segment['key'])
                elif cloud['key'] == 'logbroker':
                    LogBrokerCluster.from_str(segment['key'])
                elif cloud['key'] == 'distbuild_segment':
                    DistBuildSegment.from_str(segment['key'])
            except RequestValueError:
                print('{}: {} - {}'.format(cloud['key'], segment['key'], segment['name']))
    for resource in sb:
        try:
            SandboxSegment.from_str(resource['key'])
        except RequestValueError:
            print('Sandbox: {}'.format(resource['key']))



if __name__ == '__main__' or __name__ == 'sandbox.taskbox.binary':
    main()

