import requests
from enum import Enum
from collections import defaultdict
import os
from time import sleep


class Abc(requests.Session):
    BASE_URL = 'https://abc-back.yandex-team.ru/api/v4/'

    def __init__(self, token=None):
        super(Abc, self).__init__()
        if token is None:
            if 'ABC_TOKEN' in os.environ:
                token = os.environ['ABC_TOKEN']
            elif 'ABC_TOKEN_PATH' in os.environ:
                with open(os.path.expanduser(os.environ['ABC_TOKEN_PATH'])) as f:
                    token = f.read().strip()
            else:
                raise RuntimeError('Abc token is required')
        self.headers.update({
            'Accept': 'application/json;charset=UTF-8',
            'Content-Type': 'application/json;charset=UTF-8',
            'Authorization': 'OAuth {}'.format(token)
        })

    def get_service_by_slug_with_descendants(self, slug):
        res = self.get(self.BASE_URL + 'services/', params={'parent__with_descendants__slug': slug,
                                                            'fields': 'id,slug,parent,name'})
        results = []
        for i in range(100):
            res.raise_for_status()

            res = res.json()
            results.extend(res['results'])
            next_uri = res.get('next')
            if next_uri:
                sleep(0.5)
                res = self.get(next_uri)
            else:
                break
        return results


