# coding: utf-8

import requests
import json
import time
import datetime

from sandbox import sdk2


class FuckUpAlertsNotifier(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        tokens = sdk2.parameters.YavSecret(
            "секрет с токенами",
             default="sec-01g76s1drd1pqq7hgdppmhmt13@ver-01g799q2b6zr9gezqv74yvfhc0"
        )

    def on_execute(self):
        tokens = self.Parameters.tokens.data()
        oauth_token = tokens["auth_token"]
        bot_token = tokens["tg_token"]
        chat_id = tokens["chat_id"]
        req = requests.get(
            'https://st-api.yandex-team.ru/v2/issues?filter=queue:BERUAPPSALERTS&filter=resolution:empty()',
            headers={'Authorization': 'OAuth ' + oauth_token}).text
        tikets = json.loads(req)

        filtered = []
        prefix = "https://st.yandex-team.ru/"

        for i in tikets:
            if i['createdAt'] != "null":
                created = time.mktime(
                    datetime.datetime.strptime(i['createdAt'].split('.')[0], "%Y-%m-%dT%H:%M:%S").timetuple()
                )
                if created < time.time() - 21600:
                    link = prefix + i['key']
                    status = i['status']['display'] if 'status' in i else 'Unknown'
                    summary = i['summary']
                    filtered.append(link + ' [' + status + '] ' + summary)

        if len(filtered) != 0:
            message = """
        На сервисе обнаружен ряд проблем. Дежурные, актуализируйте статусы тикетов:
        {tics}
        """.format(tics=", \n".join(filtered))
            requests.get(
                'https://api.telegram.org/bot{}/sendMessage?chat_id={}&text={}'.format(bot_token, chat_id, message)
            )
