# coding: utf-8

import logging
import os

from sandbox import sdk2
from sandbox.projects.market.mobile.helpers.arc import MobileArc
import sandbox.common.types.client as ctc
from sandbox.sdk2.helpers import subprocess as sp


class MobileIncrementVersion(sdk2.Task, MobileArc):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX

    class Parameters(sdk2.Task.Parameters):
        branch = sdk2.parameters.String('Ветка, в которой нужно увеличить версию', required=True)
        source_path = sdk2.parameters.String('Target directory with increment version script', required=True)
        source_file_name = sdk2.parameters.String('Target increment version script file name', required=True)
        next_version = sdk2.parameters.String('Next app version', required=True)
        vault_token = sdk2.parameters.Vault(
            "Токен пользователья, от имени которого будеи произведен коммит",
            default_value='sec-01g53r2f8sv498b033ar0b5x1j[arc-mobile-token]'
        )

    def on_execute(self):
        logging.info("Starting %s task with params: %s", self.type, self.Parameters)

        target_branch = "version_incremention-" + self.Parameters.next_version
        script = self.Parameters.source_file_name
        self.arc_mount(self.Parameters.vault_token)
        target_path = os.path.join(self.arcadia, self.Parameters.source_path)

        logging.info("Script dir {}".format(target_path))
        self.arc_checkout(self.Parameters.branch)
        self.arc_checkout(target_branch, create_branch=True)

        with sdk2.helpers.ProcessLog(self, logger='incrementer') as plp:
            sp.check_call(["bash", script, "-v", self.Parameters.next_version], cwd=target_path,  stdout=plp.stdout, stderr=plp.stderr)

        self.arc_add(target_path)
        self.arc_commit("Incremented version\nSKIP_CHECK")
        self.arc_push()
        self.arc_pr_create("Incremented version of app", to=self.Parameters.branch, publish=True)

        self.arc_unmount()
