# coding=utf-8

from sandbox import sdk2
from sandbox.projects.common.vcs.arc import Arc


class MobileArc(object):

    arc = None
    mount_point = None
    arcadia = None

    def arc_mount(self, vault_key):
        arc_token = sdk2.Vault.data(vault_key)
        self.arc = Arc(arc_oauth_token=arc_token)
        self.mount_point = self.arc.mount_path(None, "trunk", fetch_all=False)
        self.arcadia = self.mount_point.__enter__()

    def arc_unmount(self):
        if self.mount_point and self.mount_point.mounted:
            self.mount_point.unmount()
            self.mount_point = None

    def arc_checkout(self, branch_name, create_branch=False):
        if not branch_name:
            raise ValueError("branch_name is not defined")
        return self.arc.checkout(
            self.arcadia,
            branch=branch_name,
            create_branch=create_branch
        )

    def arc_commit(self, message):
        return self.arc.commit(self.arcadia, message=message, all_changes=True)

    def arc_add(self, path=None):
        return self.arc.add(self.arcadia, path=path, all_changes=True)

    def arc_push(self, upstream=None):
        return self.arc.push(
            self.arcadia,
            upstream=upstream
        )

    def arc_pr_create(self, message,  to=None, publish=False):
        if not message:
            raise ValueError("Message is not defined")

        self.arc.pr_create(
            self.arcadia,
            to=to,
            message=message,
            publish=publish,
        )
