# -*- coding: utf-8 -*-


SET_CAUSE_FOR_PLAN_FACTS_SQL ="""
UPDATE plan_fact
SET
    cause = '{{cause}}',
    subcause = '{{subcause}}'
WHERE id IN (
    SELECT plan_fact.id
    FROM plan_fact
        JOIN lom_waybill_segment
            ON plan_fact.entity_id = lom_waybill_segment.id
            AND plan_fact.entity_type = 'LOM_WAYBILL_SEGMENT'
        JOIN lom_order
            ON lom_order.id = lom_waybill_segment.order_id
    WHERE
        lom_order.barcode = ANY(ARRAY{{orders}})
        AND plan_fact.producer_name = ANY(ARRAY{{producers}})
)
RETURNING id
"""


GET_PLAN_FACTS_SQL ="""
SELECT plan_fact.id
WHERE id IN (
    SELECT plan_fact.id
    FROM plan_fact
        JOIN lom_waybill_segment
            ON plan_fact.entity_id = lom_waybill_segment.id
            AND plan_fact.entity_type = 'LOM_WAYBILL_SEGMENT'
        JOIN lom_order
            ON lom_order.id = lom_waybill_segment.order_id
    WHERE
        lom_order.barcode = ANY(ARRAY{{orders}})
        AND plan_fact.producer_name = ANY(ARRAY{{producers}})
)
"""
