# -*- coding: utf-8 -*-

import requests
from sandbox import sdk2
from sandbox import common
import sandbox.common.types.task as ctt
from sandbox.projects.market.multitesting.MarketMultitestingBuildDockerImage import MarketMultitestingBuildDockerImage


class MarketMultitestingBuildAllBaseDockerImages(sdk2.Task):
    """
        Собирает все базовые Docker-образы для мультитестингов, которые ещё не переехали в RTC.
        См. https://st.yandex-team.ru/MARKETINFRA-1575 и таску MarketMultitestingBuildDockerImage.
        Эта таска умрёт с переездом мультитестингов в RTC.
    """

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        disk_space = 10 * 1024  # MB

        class Caches(sdk2.Requirements.Caches):
            pass

    class Context(sdk2.Task.Context):
        children = []

    def on_execute(self):
        with self.memoize_stage.stage1(commit_on_entrance=False):
            # общие образы
            self.build_mbi_mbo_base_image(
                image_name='market/qa/java-sec-http-proxy',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='javaSecHttpProxy',
                package_version=self.get_package_version('stable', 'yandex-java-sec-http-proxy'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/nginx-backends',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='nginxBackends',
                package_version=self.get_package_version('stable', 'config-nginx-backends'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/nginx-frontends',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='nginxFrontends',
                package_version=self.get_package_version('stable', 'config-cs-nginx-vhost'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/postfix',
                image_tag='stage-testing_envtype-none_datasources-none',
                host_group='postfix',
                package_version=self.get_package_version('testing', 'config-cs-mta'),
                environment_type='none',
                datasources_type='none',
            )

            # образы MBO
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/audit',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboAudit',
                package_version=self.get_package_version('stable', 'yandex-mbo-audit'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/card-api',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboCardApi',
                package_version=self.get_package_version('stable', 'yandex-mbo-card-api'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/cms-templates',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboCmsTemplates',
                package_version=self.get_package_version('stable', 'yandex-mbo-cms-templates'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/gurulight-ui',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboGurulightUi',
                package_version=self.get_package_version('stable', 'yandex-mbo-gurulight-ui'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/gwt',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboGwt',
                package_version=self.get_package_version('stable', 'yandex-mbo-gwt'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/http-exporter',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboHttpExporter',
                package_version=self.get_package_version('stable', 'yandex-mbo-http-exporter'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/lite',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboLite',
                package_version=self.get_package_version('stable', 'yandex-mbo-lite'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/solr',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboSolr',
                package_version=self.get_package_version('stable', 'yandex-mbo-solr'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/tms',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboTms',
                package_version=self.get_package_version('stable', 'yandex-mbo-tms'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/view-x5',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboViewX5',
                package_version=self.get_package_version('stable', 'yandex-mbo-view-x5'),
                environment_type='testing',
                datasources_type='testing',
            )
            self.build_mbi_mbo_base_image(
                image_name='market/qa/mbo/react-ui',
                image_tag='stage-stable_envtype-testing_datasources-testing',
                host_group='mboReactUi',
                package_version=self.get_package_version('stable', 'yandex-mbo-react-ui'),
                environment_type='testing',
                datasources_type='testing',
            )

            raise sdk2.WaitTask(
                self.Context.children,
                list(ctt.Status.Group.FINISH + ctt.Status.Group.BREAK),
                wait_all=True,
                timeout=8 * 60 * 60,  # 8 часов, потому что построение образов может ждать в очереди.
            )

        with self.memoize_stage.stage2(commit_on_entrance=False):
            if not all(task.status in ctt.Status.Group.SUCCEED for task in self.find(id=self.Context.children)):
                raise common.errors.TaskFailure("Not all Docker containers built (see subtasks for details)")

    def get_package_version(self, environment, package_name):
        return requests.get('https://c.yandex-team.ru/api/package_version/%s' % package_name).json()[package_name][environment]['version']

    def     build_mbi_mbo_base_image(self, image_name, image_tag, host_group, package_version, environment_type, datasources_type):
        input_parameters = {
            MarketMultitestingBuildDockerImage.Parameters.yml_file_path.name: 'playbook/services/image_build.yml',
            MarketMultitestingBuildDockerImage.Parameters.image_name.name: image_name,
            MarketMultitestingBuildDockerImage.Parameters.image_tag.name: image_tag,
            MarketMultitestingBuildDockerImage.Parameters.host_group.name: host_group,
            MarketMultitestingBuildDockerImage.Parameters.parameters.name: {
                'sandbox': 'True',
                'PACKAGE_VERSION': package_version,
                'ENVIRONMENT_TYPE': environment_type,
                'DATASOURCES_TYPE': datasources_type,
            },
        }
        self.Context.children.append(
            MarketMultitestingBuildDockerImage(
                self,
                description='Сборка образа %s:%s' % (image_name, image_tag),
                notifications=self.Parameters.notifications,
                **input_parameters
            ).enqueue().id
        )

    def build_checkouter_base_image(self, yml_file_path, image_name, image_tag):
        input_parameters = {
            MarketMultitestingBuildDockerImage.Parameters.yml_file_path.name: yml_file_path,
            MarketMultitestingBuildDockerImage.Parameters.image_name.name: image_name,
            MarketMultitestingBuildDockerImage.Parameters.image_tag.name: image_tag,
            MarketMultitestingBuildDockerImage.Parameters.host_group.name: '',
            MarketMultitestingBuildDockerImage.Parameters.parameters.name: {
                'sandbox': 'True',
                'registry_url': 'registry.yandex.net',
                'tag': image_tag,
            },
        }
        self.Context.children.append(
            MarketMultitestingBuildDockerImage(
                self,
                description='Сборка образа %s:%s' % (image_name, image_tag),
                notifications=self.Parameters.notifications,
                **input_parameters
            ).enqueue().id
        )

    def build_checkouter_mbi_support_base_image(self, yml_file_path, image_name, image_tag, service_name,
                                                package_version_variable_name, package_version):
        input_parameters = {
            MarketMultitestingBuildDockerImage.Parameters.yml_file_path.name: yml_file_path,
            MarketMultitestingBuildDockerImage.Parameters.image_name.name: image_name,
            MarketMultitestingBuildDockerImage.Parameters.image_tag.name: image_tag,
            MarketMultitestingBuildDockerImage.Parameters.host_group.name: '',
            MarketMultitestingBuildDockerImage.Parameters.parameters.name: {
                'sandbox': 'True',
                'registry_url': 'registry.yandex.net',
                'ipv6': 'true',
                'base_image_tag': image_tag,
                'service_name': service_name,
                package_version_variable_name: package_version,
            },
        }
        self.Context.children.append(
            MarketMultitestingBuildDockerImage(
                self,
                description='Сборка образа %s:%s' % (image_name, image_tag),
                notifications=self.Parameters.notifications,
                **input_parameters
            ).enqueue().id
        )
