from sandbox import sdk2
from sandbox.sdk2 import yav
from notificator import Notificator
import sandbox.projects.common.environments as env


class OfflineUxSupportDutyNotificator(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [env.PipEnvironment("python-dateutil")]

    class Parameters(sdk2.Task.Parameters):
        slug_id = sdk2.parameters.String('Service slug:', default='offline_ux')
        notification_chat_id = sdk2.parameters.Integer('Chat id for notifications:')
        enable_unpin = sdk2.parameters.Bool('Enable unpinning', default='false')
        enable_pin = sdk2.parameters.Bool('Enable pinning', default='false')
        invite_link = sdk2.parameters.String('Invite link:', default='https://t.me/joinchat/iVzaxeEoLOIxYmRi')

    def on_execute(self):
        yav_tokens = yav.Secret('sec-01g4a3a4hcchxy2h577f8x9j8s')
        notificator = Notificator(
            yav_tokens,
            self.Parameters.slug_id,
            self.Parameters.notification_chat_id,
            self.Parameters.enable_pin,
            self.Parameters.enable_unpin,
            self.Parameters.invite_link
        )
        notificator.do_notification()
