from sandbox import sdk2
from sandbox.sdk2 import yav
from escalator import Escalator
import sandbox.projects.common.environments as env


class OfflineUxTicketsEscalator(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [env.PipEnvironment("python-dateutil")]

    class Parameters(sdk2.Task.Parameters):
        escalation_chat_id = sdk2.parameters.String('Chat id:', default='')
        checkouter_filter_id = sdk2.parameters.String('Checkouter filter id:', default='439694')
        ios_filter_id = sdk2.parameters.String('iOS filter id:', default='439770')
        android_filter_id = sdk2.parameters.String('Android filter id:', default='439771')
        web_filter_id = sdk2.parameters.String('Web filter id', default='439711')
        qa_filter_id = sdk2.parameters.String('QA filter id:', default='439698')

    def on_execute(self):
        yav_tokens = yav.Secret('sec-01g4a3a4hcchxy2h577f8x9j8s')
        escalator = Escalator(
            yav_tokens,
            self.Parameters.escalation_chat_id,
            self.Parameters.checkouter_filter_id,
            self.Parameters.ios_filter_id,
            self.Parameters.android_filter_id,
            self.Parameters.web_filter_id,
            self.Parameters.qa_filter_id
        )
        escalator.do_escalation()
