# coding: utf8

import logging
import os

from sandbox import sdk2
import sandbox.projects.market.resources as market_resources


class RunCostForecaster(sdk2.Task):
    """https://a.yandex-team.ru/arc/trunk/arcadia/market/opsmode/CostForecaster/README.md
    """
    class Parameters(sdk2.Task.Parameters):
        app_resource_id = sdk2.parameters.LastResource(
            "Resource cost forecaster application",
            resource_type=market_resources.MARKET_COST_FORECASTER_APP,
        )

    def on_execute(self):
        logging.info('started')
        yt_token = sdk2.Vault.data('OPSMODA', 'OPSMODA_YT_TOKEN')
        yql_token = sdk2.Vault.data('OPSMODA', 'OPSMODA_YQL_TOKEN')

        app_tar_path = str(sdk2.ResourceData(self.Parameters.app_resource_id).path)
        args = [
            'tar',
            '-xzf',
            app_tar_path,
        ]
        sdk2.helpers.subprocess.check_call(args)

        env = os.environ.copy()
        env.update({
            'YT_TOKEN': yt_token,
            'YQL_TOKEN': yql_token,
        })
        with sdk2.helpers.ProcessLog(self, logger='run') as pl:
            sdk2.helpers.subprocess.check_call(
                [
                    './CostForecaster',
                    '--from-sandbox',
                ],
                env=env,
                stdout=pl.stdout,
                stderr=pl.stderr,
                close_fds=True,
                cwd='cost_forecaster',
            )
        logging.info('finished')
