from sandbox import sdk2

import sandbox.common.share as common_share
from sandbox.sdk2 import parameters
from sandbox.sdk2 import Task

import sandbox.projects.common.nanny.nanny as nanny

from sandbox.projects.market.parametrizator.resources import PARAMETRIZATOR_DATA_FROM_IDX

import api.copier.errors as copier_errors
import logging


class ReleaseParametrizatorData(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
    Release to nanny parametrizator data by skynet id
    Remote copy resource with nanny tickets integration support2
    """

    class Parameters(Task.Parameters):
        with parameters.String("Environment type", required=True) as environment_type:
            environment_type.values["stable"] = environment_type.Value("STABLE")
            environment_type.values["testing"] = environment_type.Value("TESTING")
        rbtorrent_id = parameters.String("skynet id of data from idx", required=True)

    def on_execute(self):
        super(ReleaseParametrizatorData, self).on_execute()
        logging.info("executing task")
        try:
            common_share.skynet_get(self.Parameters.rbtorrent_id, 'parametrizator_data')
        except copier_errors.CopierError as e:
            logging.exception("Cannot download resource with id %s. Exception %s", self.Parameters.rbtorrent_id, e)
            raise

        data = sdk2.ResourceData(
            PARAMETRIZATOR_DATA_FROM_IDX(self, 'Parametrizator files from idx', 'parametrizator_data')
        )
        data.ready()

    def on_success(self, prev_status):
        Task.on_success(self, prev_status)
        additional_parameters = dict(
            release_comments=None,
            release_status=self.Parameters.environment_type,
            release_subject="Auto release new resource for parametrizator from sandbox",
            releaser=self.author,
        )
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
