from sandbox import sdk2
from sandbox.sdk2 import service_resources
import logging


class MarketPricelabsTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        env = sdk2.parameters.String("Environment", default="production", required=True)
        tokens = sdk2.parameters.YavSecret("Yandex Vault secret with YT and YQL keys",
                                           default="sec-01dyhqrrt0w9dexta0cxs3arrp@ver-01ehcf46wkn021yrdbn2x80rg2",
                                           required=True)

        use_last_binary = sdk2.parameters.Bool("Use last binary archive", default=True)
        with use_last_binary.value[True]:
            with sdk2.parameters.RadioGroup("Binary release type") as release_type:
                release_type.values.stable = release_type.Value('stable', default=True)
                release_type.values.test = release_type.Value('test')

    def on_save(self):
        if self.Parameters.use_last_binary:
            self.Requirements.tasks_resource = service_resources.SandboxTasksBinary.find(
                attrs={'target': 'market/pricelabs/task',
                       'release': self.Parameters.release_type or 'stable'}).first().id

    def before_execute(self):
        secret_data = self.Parameters.tokens.data()

        self.yt_token = secret_data["hahn.yt.yandex.net_oauth"]
        self.yql_token = secret_data["yql.yandex.net_oauth"]

        from yt.wrapper import default_config as cfg
        cfg.default_config['token'] = self.yt_token

        from yt.transfer_manager import client as tm
        try:
            tm.global_client.init_client(token=self.yt_token)
        except BaseException as e:
            logging.error("Unable to configure TM client %s", e)
