import logging
from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.projects.common import binary_task, task_env


class TicketErrorsInfo(sdk2.Resource):
    errors = sdk2.parameters.String("Checkers errors")


class TicketError(Exception):
    def __init__(self, message):
        self.message = message


class PromocoordinatorActionChecker(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        ticket_id = sdk2.parameters.String('Startrack ticket', required=True)
        filter_id = sdk2.parameters.String('Filter id', required=True)

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        logging.root.setLevel(logging.DEBUG)
        from market.promocoordinator.tasks.promo_tickets_checker import main_task

        st_token_sec = yav.Secret('sec-01efw4gwaq632722tep9rhem23')

        st_token = st_token_sec.data()['st-token']

        errors = main_task({
            'st_token': st_token,
            'ticket_id': self.Parameters.ticket_id,
            'filter_id': self.Parameters.filter_id,
            'env': self.Parameters.binary_executor_release_type
        })

        if len(errors) > 0:
            logging.error(errors)

            resource = TicketErrorsInfo(
                self, 'Erros in ticket: {}'.format(self.Parameters.ticket_id), 'errors.txt'
            )
            resource.path.write_bytes(errors.encode())

            logging.info('Resource created')

            raise TicketError(errors)

