import logging

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.projects.common import task_env, binary_task


class CreatedTicketInfo(sdk2.Resource):
    tickets_count = sdk2.parameters.String("Tickets Count")


class PromocoordinatorCreatorTask(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        queue = sdk2.parameters.String('Startrack queue', required=True)
        dashboard_link = sdk2.parameters.String('Dashboard Filter', default='https://st.yandex-team.ru/issues/397989',
                                                required=False)

        with sdk2.parameters.String("Cluster") as cluster:
            cluster.values[''] = ''
            cluster.values.ARNOLD = 'arnold'
            cluster.values.HAHN = 'hahn'

        with sdk2.parameters.String("Strategy") as strategy:
            strategy.values.ALL = 'all'
            strategy.values.DESIGN = 'design'
            strategy.values.MARCOM = 'marcom'
            strategy.values.INFORMER = 'informer'

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        logging.root.setLevel(logging.DEBUG)
        from market.promocoordinator.tasks.reader import main_task

        st_token_sec = yav.Secret('sec-01efw4gwaq632722tep9rhem23')
        yt_token_sec = yav.Secret('sec-01efw4e0830ge8s2dhyj5kkh88')
        yql_token_sec = yav.Secret('sec-01f1g0hrkecvtnhw98wfda651q')
        oauth_token_sec = yav.Secret('sec-01erck1hny9cxy3c4gjw9xgwxn')
        staff_token_sec = yav.Secret('sec-01fekaddah6046aqe69ztnap9c')

        st_token = st_token_sec.data()['st-token']
        yt_token = yt_token_sec.data()['yt-token']
        yql_token = yql_token_sec.data()['yql-token']
        oauth_token = oauth_token_sec.data()['step-promocord-auth']
        staff_token = staff_token_sec.data()['token']

        logging.debug(self.Parameters.binary_executor_release_type)

        sample = main_task({
            'st_token': st_token,
            'yt_token': yt_token,
            'yql_token': yql_token,
            'oauth_token': oauth_token,
            'staff_token': staff_token,
            'queue': self.Parameters.queue,
            'strategy': self.Parameters.strategy,
            'cluster': self.Parameters.cluster,
            'env': self.Parameters.binary_executor_release_type,
            'custom_data': {
                'dashboard_link': self.Parameters.dashboard_link,
            }
        })

        if sample is not None and sample.size != 0:
            data = sdk2.ResourceData(CreatedTicketInfo(
                self, "Created tickets", "tickets"
            ))

            sample.to_csv('tickets')

            data.ready()

            logging.info('Resource created')
