import logging
import json

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.projects.common import binary_task, task_env


class PromocoordinatorIndexerChecker(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        waremd5 = sdk2.parameters.String('waremd5', required=True)
        shop_promo_id = sdk2.parameters.String('ShopPromoId', required=True)
        with sdk2.parameters.String("Master Cluster") as master:
            master.values.GIBSON = 'gibson'
            master.values.STRATOCASTER = 'stratocaster'

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        logging.root.setLevel(logging.DEBUG)
        from market.promocoordinator.tasks.promo_indexer_checker import main_task

        yql_token_sec = yav.Secret('sec-01f1g0hrkecvtnhw98wfda651q')
        yt_token_sec = yav.Secret('sec-01efw4e0830ge8s2dhyj5kkh88')

        yql_token = yql_token_sec.data()['yql-token']
        yt_token = yt_token_sec.data()['yt-token']

        result = main_task({
            'yql_token': yql_token,
            'yt_token': yt_token,
            'waremd5': self.Parameters.waremd5,
            'master': self.Parameters.master.lower(),
            'shop_promo_id': self.Parameters.shop_promo_id,
            'env': self.Parameters.binary_executor_release_type
        })

        self.set_info(json.dumps(result, indent=4, ensure_ascii=False), do_escape=False)


