import logging

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.projects.common import binary_task, task_env


class PromocoordinatorPromoInforming(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):

        with sdk2.parameters.String("Cluster") as cluster:
            cluster.values[''] = ''
            cluster.values.ARNOLD = 'arnold'
            cluster.values.HAHN = 'hahn'

        queue = sdk2.parameters.String(
            'Startrek queue',
            required=True
        )

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        logging.root.setLevel(logging.DEBUG)

        from market.promocoordinator.tasks.promo_informing import main_task

        yql_token_sec = yav.Secret('sec-01f1g0hrkecvtnhw98wfda651q')
        yql_token = yql_token_sec.data()['yql-token']

        oauth_token_sec = yav.Secret('sec-01erck1hny9cxy3c4gjw9xgwxn')
        step_oauth_token = oauth_token_sec.data()['step-promocord-auth']

        st_token_sec = yav.Secret('sec-01efw4gwaq632722tep9rhem23')
        startrek_token = st_token_sec.data()['st-token']

        yt_token_sec = yav.Secret('sec-01efw4e0830ge8s2dhyj5kkh88')
        yt_token = yt_token_sec.data()['yt-token']

        logging.debug(self.Parameters.binary_executor_release_type)

        result = main_task({
            'env': self.Parameters.binary_executor_release_type,
            'st_token': startrek_token,
            'yt_token': yt_token,
            'yql_token': yql_token,
            'oauth_token': step_oauth_token,
            'cluster': self.Parameters.cluster,
            'queue': self.Parameters.queue,
        })

        self.set_info(result, do_escape=False)
