import logging
import json

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.projects.common import binary_task, task_env


class PromocoordinatorUpdaterTask(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.String("Cluster") as cluster:
            cluster.values[''] = ''
            cluster.values.ARNOLD = 'arnold'
            cluster.values.HAHN = 'hahn'

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        logging.root.setLevel(logging.DEBUG)
        from market.promocoordinator.tasks.updater import main_task

        st_token_sec = yav.Secret('sec-01efw4gwaq632722tep9rhem23')
        st_token = st_token_sec.data()['st-token']

        yt_token_sec = yav.Secret('sec-01efw4e0830ge8s2dhyj5kkh88')
        yt_token = yt_token_sec.data()['yt-token']

        oauth_token_sec = yav.Secret('sec-01erck1hny9cxy3c4gjw9xgwxn')
        step_oauth_token = oauth_token_sec.data()['step-promocord-auth']

        yql_token_sec = yav.Secret('sec-01f1g0hrkecvtnhw98wfda651q')
        yql_token = yql_token_sec.data()['yql-token']

        result = main_task({
            'st_token': st_token,
            'yt_token': yt_token,
            'yql_token': yql_token,
            'step_oauth_token': step_oauth_token,
            'cluster': self.Parameters.cluster,
            'env': self.Parameters.binary_executor_release_type
        })

        logging.debug(json.dumps(result, indent=4, ensure_ascii=False))

        self.set_info(
            '<b>Table:</b> <a class="status status_success" target="_blank" href="{}">{}</a><br/>'.format(
                result["table_link"], result["table_path"]
            ) +
            '<b>Event:</b> <a class="status status_success" target="_blank" href="{}">{}</a><br/>'.format(
                result["event_link"], result["event_id"]
            ) +
            '<b>Filter:</b> <a class="status status_draft" target="_blank" href="{}">{}</a><br/>'.format(
                result["filter_link"], result["filter_value"]
            ) +
            '<b>Tickets count:</b> {}'.format(result["tickets_count"]),
            do_escape=False,
        )
