# -*- coding: utf-8 -*-
import logging
import json
import time
import requests

from sandbox import sdk2


class BlueMarketStatRealiseTesters(sdk2.Task):
    """ Get BLUEMARKET release statistics and send it to statface """

    def on_execute(self):
        secret_name_testpalm = "robot-market-autotst-oauth-testpalm"
        secret_name_statface = "robot-market-autotst-oauth-statface"
        secret_name_st = "robot-market-autotst-oauth-st"

        testpalm_token = sdk2.Vault.data(secret_name_testpalm)
        stat_token = sdk2.Vault.data(secret_name_statface)
        tracker_token = sdk2.Vault.data(secret_name_st)

        s = requests.Session()
        urlD = "https://testpalm.yandex-team.ru/api/testrun/bluemarket/preview?status=FINISHED"
        urlT = "https://testpalm.yandex-team.ru/api/testrun/bluemarketapps/preview?status=FINISHED"
        urlC_D = "https://st-api.yandex-team.ru/v2/issues/?filter=queue:BLUEMARKET&filter=type:bug&filter=priority:critical%7Cblocker&filter=stand:Production"
        urlC_T = "https://st-api.yandex-team.ru/v2/issues/?filter=queue:BLUEMARKETAPPS&filter=type:bug&filter=priority:critical%7Cblocker&filter=stand:Production"

        my_list = []
        versions = []
        fix_versions = s.get(
            "https://st-api.yandex-team.ru/v2/queues/BLUEMARKET/versions",
            headers={'Authorization': 'OAuth {}'.format(tracker_token)},
        )

        parsed_string_tracker = json.loads(fix_versions.text)

        desktop = s.get(
                        urlD,
                        headers={'Authorization': 'OAuth {}'.format(testpalm_token)},
                    )
        touch = s.get(
                        urlT,
                        headers={'Authorization': 'OAuth {}'.format(testpalm_token)},
                    )
        crit_desktop = s.get(
                        urlC_D,
                        headers={'Authorization': 'OAuth {}'.format(tracker_token)},
                    )

        crit_touch = s.get(
                        urlC_T,
                        headers={'Authorization': 'OAuth {}'.format(tracker_token)},
                    )
        parsed_string_D = json.loads(desktop.text)
        parsed_string_T = json.loads(touch.text)
        parsed_string_C_D = json.loads(crit_desktop.text)
        # parsed_string_C_T = json.loads(crit_touch.text)

        timelist=[]
        timelist.append("ddd")

        vare = []
        fieldnames= "fielddate,name,release_count,critical_name,ticket_count,hotfix,desktop_time,desktop_time_name,desktop_run_name,tester_desktop,touch_time,touch_time_name,touch_run_name,tester_touch".split(",")
        for values in parsed_string_tracker[0:]:
            realise = s.get(
                 "https://st-api.yandex-team.ru/v2/issues/?filter=queue:BLUEMARKET&filter=fixVersions:"+str(values["id"]),
                headers={'Authorization': 'OAuth {}'.format(tracker_token)},
                )
            parsed_realise = json.loads(realise.text)
            gra=[]
            gra = str(values["name"]).split('.')

            for values2 in parsed_realise[0:]:
                vare = []

                if values2["type"]["key"] == "release":
                    flag = 0

                    for i in timelist[0:]:

                        teststr=(str(values2["createdAt"])[0:16]+":00")
                        if i == teststr:
                            flag = 1
                            break

                        else:
                            flag = 0

                    if flag == 1:

                        vare.append(str(values2["createdAt"][0:15] + str(int(values2["createdAt"][15])+1)+":00"))
                        timelist.append(str(values2["createdAt"][0:15] + str(int(values2["createdAt"][15])+1))+":00")
                    else:
                        vare.append(str(values2["createdAt"])[0:16]+":00")
                        timelist.append(str(values2["createdAt"])[0:16]+":00")

                    vare.append(values2["summary"])  # name
                    if gra[2] == '0' or gra[2] == "0d" or gra[2] == "0m":
                        vare.append("1")  # release_count

                    else:
                        vare.append("0")  # release_count

                    vare.append("https://st.yandex-team.ru/"+values2["key"])
                    vare.append(len(parsed_realise)-1)  # ticket_count

                    if gra[2] == '0' or gra[2] == "0d" or gra[2] == "0m":
                        vare.append("0")

                    else:
                        vare.append("1")  # hotfix

                    for values3 in parsed_string_D[0:]:

                            if values3["createdBy"] != "robot-metatron":
                                if ("parentIssue" in values3) and ("id" in values3["parentIssue"]):
                                    if values3["parentIssue"]["id"] == values2["key"]:

                                        if ((values3["executionTime"] // 1000) / 60 / 60) > 9:

                                            vare.append('9')  # desktop_time
                                            vare.append("9 ч.")  # desktop_time_name
                                        else:
                                            vare.append(((values3["executionTime"] // 1000) / 60 / 60))  # desktop_time
                                            vare.append(str(
                                                round((((values3["executionTime"] // 1000) / 60 / 60)) // 1)) + " ч : " + str(
                                                round(((((values3[
                                                              "executionTime"] // 1000) / 60 / 60)) % 1) * 60)) + " м")

                                        vare.append("https://testpalm.yandex-team.ru/bluemarket/testrun/" + values3["id"])  # destktop_run_name
                                        vare.append(','.join(values3["participants"]))  # tester_desktop

                    for values4 in parsed_string_T[0:]:

                            if values4["createdBy"] != "robot-metatron":
                                if ("parentIssue" in values4) and ("id" in values4["parentIssue"]):
                                    if values4["parentIssue"]["id"] == values2["key"]:
                                        if ((values4["executionTime"] // 1000) / 60 / 60) > 9:

                                            vare.append('9')  # touch_time
                                            vare.append("9 ч.")  # touch_time_name
                                        else:
                                            vare.append(((values4["executionTime"] // 1000) / 60 / 60))  # touch_time
                                            vare.append(str(
                                                round((((values4["executionTime"] // 1000) / 60 / 60)) // 1)) + " ч : " + str(
                                                round(((((values4[
                                                              "executionTime"] // 1000) / 60 / 60)) % 1) * 60)) + " м")#  touch_time_name

                                        vare.append("https://testpalm.yandex-team.ru/bluemarketapps/testrun/" + values4["id"])  #  touch_run_name
                                        vare.append(','.join(values4["participants"]))  # tester_touch

                    my_list.append(dict(zip(fieldnames, vare)))

        fieldnames_2 = "fielddate,name,critical,critical_name".split(",")

        for values5 in parsed_string_C_D[0:]:
            crits = []

            for i in timelist[0:]:

                teststr = (str(values5["createdAt"])[0:16] + ":00")
                if i == teststr:
                    flag = 1
                    break

                else:
                    flag = 0

            if flag == 1:
                crits.append(str(values5["createdAt"][0:15] + str(int(values5["createdAt"][14-15]) + 1) + ":00")) # fieldsdate
                timelist.append(str(values5["createdAt"][0:15] + str(int(values5["createdAt"][14-15]) + 1)) + ":00") # fieldsdate
            else:
                crits.append(str(values5["createdAt"])[0:16] + ":00")
                timelist.append(str(values5["createdAt"])[0:16] + ":00")

            crits.append(values5["summary"])  # name
            crits.append('1') #crit
            crits.append("https://st.yandex-team.ru/" + values5["key"])
            my_list.append(dict(zip(fieldnames_2, crits)))

        name = '/Market/BlueMarket/qa_frontend_report/QA_report_desktop_touch/'
        scale = 'i'
        arr_D = { "values":  list(reversed(my_list))}
        strr_D = json.dumps(arr_D)

        r = requests.post(
                'https://upload.stat.yandex-team.ru/_api/report/data',
                headers={'Authorization': 'OAuth {}'.format(stat_token)},
                data={
                'name': name,
                'scale': scale,
                'data': strr_D,
                },
                verify=False,
        )

