# -*- coding: utf-8 -*-
import json
import requests
import time
import logging
import datetime

from sandbox import sdk2


class MarketAffiliateTestingMetrics(sdk2.Task):
    """ Get testing statistics and send it to statface """

    def on_execute(self):

        def get_json_data(session, url):
            tmp = session.get(url)
            logging.info('Response from ' + url)
            logging.info(tmp)
            return json.loads(tmp.text)

        secret_name_statface = "robot-market-autotst-oauth-statface"
        stat_token = sdk2.Vault.data(secret_name_statface)

        secret_name_st = "robot-market-autotst-oauth-st"
        st_token = sdk2.Vault.data(secret_name_st)
        st_session = requests.Session()
        st_session.headers.update({'Authorization': 'OAuth {}'.format(st_token)})

        secret_name_testpalm = "robot-market-autotst-oauth-testpalm"
        testpalm_token = sdk2.Vault.data(secret_name_testpalm)
        testpalm_session = requests.Session()
        testpalm_session.headers.update({'Authorization': 'OAuth {}'.format(testpalm_token)})

        url_testpalm = "https://testpalm-api.yandex-team.ru/testrun/market-affiliate?include=resolution%2CparentIssue%2CexecutionTime&expression=%7B%22type%22%3A%22AND%22%2C%22left%22%3A%7B%22type%22%3A%22GT%22%2C%22key%22%3A%22createdTime%22%2C%22value%22%3A%221554080400000%22%7D%2C%22right%22%3A%7B%22type%22%3A%22NEQ%22%2C%22key%22%3A%22createdBy%22%2C%22value%22%3A%22robot-metatron%22%7D%7D"
        url_st_versions = "https://st-api.yandex-team.ru/v2/queues/MARKETAFFILIATE/versions"
        url_st_issues_in_versions = "https://st-api.yandex-team.ru/v2/issues/?filter=queue:MARKETAFFILIATE&filter=fixVersions:"

        release_list = []

        parsed_fix_version = get_json_data(st_session, url_st_versions)

        parsed_testpalm = get_json_data(testpalm_session, url_testpalm)

        for fix_version in parsed_fix_version[0:]:
            parsed_release = get_json_data(st_session, url_st_issues_in_versions + str(fix_version["id"]))

            for current_release_value in parsed_release[0:]:
                if current_release_value["type"]["key"] == "release" and \
                   current_release_value["status"]["key"] == "closed":
                    release_dict = {"fielddate": str(current_release_value["resolvedAt"][0:19]),
                                    "name": current_release_value["summary"],
                                    "ticket_count": len(parsed_release) - 1,
                                    "release_url": "https://st.yandex-team.ru/" + current_release_value["key"],
                                    "hotfix": "0",
                                    "release_count": "1"}
                    manual_regression_times = [0, 0, 0, 0]
                    for testpalm_values in parsed_testpalm[0:]:
                        # Время выполнения в минутах
                        executionTime = testpalm_values["executionTime"] / 1000 / 60
                        if executionTime > 0 and \
                           "parentIssue" in testpalm_values and \
                           testpalm_values["parentIssue"] != None and \
                           "id" in testpalm_values["parentIssue"] and \
                           testpalm_values["parentIssue"]["id"] == current_release_value["key"]:
                            manual_regression_times[0] += executionTime
                            manual_regression_times[1] += 1
                            manual_regression_times[2] += testpalm_values["resolution"]["counter"]["passed"]
                            manual_regression_times[3] += testpalm_values["resolution"]["counter"]["total"]
                    # если есть ручной ран - добавляем значения
                    if (manual_regression_times[1]):
                        release_dict["manual_regression_time"] = manual_regression_times[0]
                        release_dict["manual_regression_run_count"] = manual_regression_times[1]
                        release_dict["manual_regression_all_passed"] = manual_regression_times[2]
                        release_dict["manual_regression_all"] = manual_regression_times[3]
                    release_list.append(release_dict)

        name = '/Market/Testing/Affiliate/releases/'
        scale = 's'
        strr_D = json.dumps({"values": list(reversed(release_list))})

        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth {}'.format(stat_token)},
            data={
                'name': name,
                'scale': scale,
                'data': strr_D,
            },
            verify=False,
        )
        logging.info(r)

