# -*- coding: utf-8 -*-
import logging
import json
import datetime
import requests
import copy

from sandbox import sdk2


class MarketCrmMetrics(sdk2.Task):
    """ Get testing statistics and send it to statface """

    def on_execute(self):

        def get_json_data(session, url):
            tmp = session.get(url)
            logging.info('Response from ' + url)
            logging.info(tmp)
            return json.loads(tmp.text)

        def if_testing_missed_a_bug(cause_id):
            causes_of_missing_a_bug = [
                {
                    'name': u'Нет кейса, новая фича',
                    'st_id': 426,
                    'is_test_missing': 1,
                }, {
                    'name': u'Нет кейса, старая фича',
                    'st_id': 427,
                    'is_test_missing': 1,
                }, {
                    'name': u'Кейс не был включён в регресс',
                    'st_id': 428,
                    'is_test_missing': 1,
                }, {
                    'name': u'Пропущен командой в регрессе',
                    'st_id': 485,
                    'is_test_missing': 1,
                }, {
                    'name': u'Пропущен асессорами в регрессе',
                    'st_id': 430,
                    'is_test_missing': 1,
                }, {
                    'name': u'Специфичный кейс',
                    'st_id': 431,
                    'is_test_missing': 1,
                }, {
                    'name': u'Специфичное окружение',
                    'st_id': 432,
                    'is_test_missing': 1,
                }, {
                    'name': u'Технический баг',
                    'st_id': 433,
                    'is_test_missing': 0,
                }, {
                    'name': u'Сторонний сервис',
                    'st_id': 434,
                    'is_test_missing': 0,
                }, {
                    'name': u'Нарушение процессов',
                    'st_id': 436,
                    'is_test_missing': 1,
                }, {
                    'name': u'Причина неизвестна',
                    'st_id': 437,
                    'is_test_missing': 1,
                }, {
                    'name': u'Проблема пропущена менеджером',
                    'st_id': 450,
                    'is_test_missing': 0,
                }, {
                    'name': u'Проблема пропущена аналитиком',
                    'st_id': 451,
                    'is_test_missing': 0,
                }, {
                    'name': u'Особенности автотестов',
                    'st_id': 452,
                    'is_test_missing': 1,
                }, {
                    'name': u'Неполнота тестирования',
                    'st_id': 453,
                    'is_test_missing': 1,
                }, {
                    'name': u'Непродуманный изначальный вариант',
                    'st_id': 454,
                    'is_test_missing': 1,
                }, {
                    'name': u'Неочевидные зависимости',
                    'st_id': 455,
                    'is_test_missing': 1,
                }, {
                    'name': u'Не воспроизводится',
                    'st_id': 46,
                    'is_test_missing': 0,
                }, {
                    'name': u'Не баг, а фича',
                    'st_id': 456,
                    'is_test_missing': 0,
                }, {
                    'name': u'Тестировалось на тестовых данных',
                    'st_id': 457,
                    'is_test_missing': 1,
                }, {
                    'name': u'Ошибка внешнего сервиса',
                    'st_id': 458,
                    'is_test_missing': 0,
                }, {
                    'name': u'Пропущено в последних итерациях тестирования',
                    'st_id': 459,
                    'is_test_missing': 1,
                }, {
                    'name': u'Редкий кейс',
                    'st_id': 460,
                    'is_test_missing': 1,
                }, {
                    'name': u'Тестовое окружение',
                    'st_id': 461,
                    'is_test_missing': 1,
                }, {
                    'name': u'Дубликат',
                    'st_id': 463,
                    'is_test_missing': 0,
                }, {
                    'name': u'Не баг, неточность в кейсе',
                    'st_id': 464,
                    'is_test_missing': 0,
                }, {
                    'name': u'Слабоподдерживаемый браузер',
                    'st_id': 465,
                    'is_test_missing': 0,
                }, {
                    'name': u'Бэкенд',
                    'st_id': 466,
                    'is_test_missing': 1,
                }, {
                    'name': u'Не баг, ошибка асессора',
                    'st_id': 467,
                    'is_test_missing': 0,
                }, {
                    'name': u'Особенности прод.окружения',
                    'st_id': 486,
                    'is_test_missing': 1,
                }, {
                    'name': u'Источник - задача no_test',
                    'st_id': 487,
                    'is_test_missing': 1,
                }, {
                    'name': u'Плохое ТЗ',
                    'st_id': 488,
                    'is_test_missing': 1,
                }, {
                    'name': u'Причина не нужна',
                    'st_id': 515,
                    'is_test_missing': 0,
                }, {
                    'name': u'Найден командой при первичном тестировании',
                    'st_id': 529,
                    'is_test_missing': 1,
                }, {
                    'name': u'Ограниченное время на тестирование',
                    'st_id': 530,
                    'is_test_missing': 1,
                }, {
                    'name': u'Передача задачи от одного тестировщика другому в процессе тестирования',
                    'st_id': 531,
                    'is_test_missing': 1,
                }
            ]
            for j in causes_of_missing_a_bug:
                if str(cause_id) == str(j['st_id']):
                    return j['is_test_missing']

        def get_week_day(_datetime):
            week_day = int(_datetime.strftime('%w'))
            if week_day == 0:
                week_day = 7
            return week_day

        def count_work_hours(changing_time):
            tmp = 0
            total_rft_time = datetime.timedelta(days=0)
            while tmp < len(changing_time) / 2:
                # work hours 04:00 - 14:00 UTC (09:00 - 19:00 EKB)
                start_work_time = '04:00:00'
                end_work_time = '14:00:00'
                start_time = datetime.datetime.strptime(
                    changing_time[tmp * 2],
                    '%Y-%m-%dT%H:%M:%S'
                )
                end_time = datetime.datetime.strptime(
                    changing_time[(tmp * 2) + 1],
                    '%Y-%m-%dT%H:%M:%S'
                )
                tmp += 1
                # normalizing start_time
                if int(start_time.strftime('%H')) < 4:
                    start_time = datetime.datetime.strptime(
                        str(start_time.strftime('%Y-%m-%d')) + 'T' + start_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                elif int(start_time.strftime('%H')) >= 14:
                    start_time = datetime.datetime.strptime(
                        str(start_time.strftime('%Y-%m-%d')) + 'T' + start_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                    start_time += datetime.timedelta(days=1)
                # TODO: add Russian holidays
                if get_week_day(start_time) == 6:
                    start_time = datetime.datetime.strptime(
                        str(start_time.strftime('%Y-%m-%d')) + 'T' + start_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                    start_time += datetime.timedelta(days=2)
                elif get_week_day(start_time) == 7:
                    start_time = datetime.datetime.strptime(
                        str(start_time.strftime('%Y-%m-%d')) + 'T' + start_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                    start_time += datetime.timedelta(days=1)
                # normalizing end_time
                if int(end_time.strftime('%H')) < 4:
                    end_time = datetime.datetime.strptime(
                        str(end_time.strftime('%Y-%m-%d')) + 'T' + end_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                    end_time -= datetime.timedelta(days=1)
                elif int(end_time.strftime('%H')) >= 14:
                    end_time = datetime.datetime.strptime(
                        str(end_time.strftime('%Y-%m-%d')) + 'T' + end_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                # TODO: add Russian holidays
                if get_week_day(end_time) == 6:
                    end_time = datetime.datetime.strptime(
                        str(end_time.strftime('%Y-%m-%d')) + 'T' + end_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                    end_time -= datetime.timedelta(days=1)
                elif get_week_day(end_time) == 7:
                    end_time = datetime.datetime.strptime(
                        str(end_time.strftime('%Y-%m-%d')) + 'T' + end_work_time,
                        '%Y-%m-%dT%H:%M:%S'
                    )
                    end_time -= datetime.timedelta(days=2)
                tmp_datetime = datetime.datetime.strptime(
                    str(start_time.strftime('%Y-%m-%d')) + 'T' + '23:59:59',
                    '%Y-%m-%dT%H:%M:%S'
                )
                delta = end_time - start_time
                workdays_counter = 0
                holiday_counter = 0
                while tmp_datetime < end_time:
                    if get_week_day(tmp_datetime) == 6:
                        holiday_counter += 1
                    elif get_week_day(tmp_datetime) == 7:
                        holiday_counter += 1
                    else:
                        workdays_counter += 1
                    tmp_datetime += datetime.timedelta(days=1)
                delta -= datetime.timedelta(days=holiday_counter)
                delta -= datetime.timedelta(hours=14 * workdays_counter)
                total_rft_time += delta
            return total_rft_time.seconds

        def count_qa_spent_time(qa_spent_string):
            qa_spent_int = 0
            qa_spent_len = len(qa_spent_string)
            if qa_spent_len > 2:
                if qa_spent_string[2] == 'D':
                    qa_spent_int = 8 * 60 * int(qa_spent_string[1])
                    qa_spent_string = 'P' + qa_spent_string[3:qa_spent_len]
                    qa_spent_len = len(qa_spent_string)
                if qa_spent_len > 3:
                    if qa_spent_string[3] == 'D':
                        qa_spent_int = 8 * 60 * int(qa_spent_string[1:3])
                        qa_spent_string = 'P' + qa_spent_string[4:qa_spent_len]
                        qa_spent_len = len(qa_spent_string)
            if qa_spent_len > 3:
                if qa_spent_string[3] == 'H':
                    qa_spent_int += 60 * int(qa_spent_string[2])
                    qa_spent_string = 'PT' + qa_spent_string[4:qa_spent_len]
                    qa_spent_len = len(qa_spent_string)
            if qa_spent_len > 4:
                if qa_spent_string[4] == 'H':
                    qa_spent_int += 60 * int(qa_spent_string[2:4])
                    qa_spent_string = 'PT' + qa_spent_string[5:qa_spent_len]
                    qa_spent_len = len(qa_spent_string)
            if qa_spent_string[qa_spent_len - 1] == 'M':
                qa_spent_int += int(qa_spent_string[2:qa_spent_len - 1])
            return qa_spent_int

        secret_name_statface = "robot-market-autotst-oauth-statface"
        stat_token = sdk2.Vault.data(secret_name_statface)

        secret_name_st = "robot-market-autotst-oauth-st"
        st_token = sdk2.Vault.data(secret_name_st)
        st_session = requests.Session()
        st_session.headers.update({'Authorization': 'OAuth {}'.format(st_token)})

        secret_name_testpalm = "robot-market-autotst-oauth-testpalm"
        testpalm_token = sdk2.Vault.data(secret_name_testpalm)
        testpalm_session = requests.Session()
        testpalm_session.headers.update({'Authorization': 'OAuth {}'.format(testpalm_token)})

        url_ocrm_rft = 'https://st-api.yandex-team.ru/v2/issues/?query=Queue:OCRM and Status:"Ready For Test"'
        url_ocrm_st_versions = 'https://st-api.yandex-team.ru/v2/queues/OCRM/versions'
        url_ocrm_st_sprints = 'https://st-api.yandex-team.ru/v2/boards/3452/sprints'
        url_ocrm_st_issues_in_versions = 'https://st-api.yandex-team.ru/v2/issues/?filter=queue:OCRM&filter=fixVersions:'
        url_ocrm_st_issues_in_sprint = 'https://st-api.yandex-team.ru/v2/issues/?filter=queue:OCRM&perPage=200&filter=sprint:'
        url_testpalm_scrm_autotest = 'https://testpalm.yandex-team.ru/api/testcases/sugarcrm/groups/testsuite/5da410dcf97f247feef2a9db'
        url_testpalm_scrm_all = 'https://testpalm.yandex-team.ru/api/testcases/sugarcrm/groups/testsuite/5d5e2af7a6a6dd7b6b3e8c52'
        url_ocrm_crit_and_blocker = 'https://st-api.yandex-team.ru/v2/issues/?query=Queue: OCRM AND (Priority: Critical OR Priority: Blocker or Type: Инцидент) AND (Type: Bug OR Type: Incident) "Sort By": updated DESC&perPage=100'

        # oCRM
        # count the number of issues in oCRM queue
        parsed_ocrm_rft = get_json_data(st_session, url_ocrm_rft)
        keys = []
        for ocrm_rft_issues in parsed_ocrm_rft:
            keys.append(ocrm_rft_issues['key'])
        ocrm_rft_to_stat = {'fielddate': str(datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')),
                            'rft_count': str(len(parsed_ocrm_rft)),
                            'keys': ', '.join(keys)}

        # count critical and blocker issues oCRM
        logging.info('count critical and blocker issues oCRM')
        ocrm_st_bad_issues = get_json_data(st_session, url_ocrm_crit_and_blocker)
        ocrm_bad_issues = []
        resolved_ocrm_issues = []
        for issue in ocrm_st_bad_issues:
            bad_issue_dict = {}
            created_time = issue['createdAt'][0:19]
            for i in resolved_ocrm_issues:
                if i['fielddate'] == created_time:
                    created_time = created_time[0:18] + str((int(created_time[18]) + 1) % 10)
            bad_issue_dict['fielddate'] = created_time
            bad_issue_dict['name'] = issue['summary']
            bad_issue_dict['issue_type'] = issue['type']['key']
            bad_issue_dict['priority'] = issue['priority']['key']
            if issue['priority']['key'] == 'blocker':
                bad_issue_dict['is_blocker'] = 1
            else:
                bad_issue_dict['is_crit'] = 1
            if 'testScope' in issue:
                if issue['testScope'] == u'Нет':
                    bad_issue_dict['test_scope'] = 0
                elif issue['testScope'] == u'Да':
                    bad_issue_dict['test_scope'] = 1
            if 'CauseOfMissingABug' in issue:
                bad_issue_dict['cause_of_problem'] = issue['CauseOfMissingABug']['display']
                bad_issue_dict['is_test_missing'] = if_testing_missed_a_bug(issue['CauseOfMissingABug']['id'])
            bad_issue_dict['key'] = issue['key']
            ocrm_bad_issues.append(bad_issue_dict)
            if 'resolvedAt' in issue:
                resolved_issue_dict = copy.deepcopy(bad_issue_dict)
                resolved_time = issue['resolvedAt'][0:19]
                for i in resolved_ocrm_issues:
                    if i['fielddate'] == resolved_time:
                        resolved_time = resolved_time[0:18] + str((int(resolved_time[18]) + 1) % 10)
                resolved_issue_dict['fielddate'] = resolved_time
                resolved_ocrm_issues.append(resolved_issue_dict)

        # clear last month in critical and blockers issues
        resp = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/delete_data/Market/CRM/testing/bugsoCRM?scale=s&_period_distance=2592000',
            # 60*60*24*30 дней
            headers={'Authorization': 'OAuth {}'.format(stat_token)},
            json={
                'execute': 1,
            },
        )
        logging.info('Clear statistic status ')
        logging.info(resp)

        # count oCRM releases statistics
        logging.info('count oCRM releases statistics')
        ocrm_release_list = []
        parsed_fix_versions = get_json_data(st_session, url_ocrm_st_versions)
        for fix_version in parsed_fix_versions:
            if fix_version['id'] > 136484 and fix_version['released']:
                parsed_release = get_json_data(
                    st_session,
                    url_ocrm_st_issues_in_versions + str(fix_version['id'])
                )
                for current_release_issue in parsed_release[0:]:
                    release_dict = {'is_release': 0}
                    parsed_issue_changelog = get_json_data(
                        st_session,
                        str(current_release_issue['self']) + '/changelog?field=status'
                    )
                    release_dict['issue'] = ['Все релизы', fix_version['name'], current_release_issue['key']]
                    release_dict['release_id'] = fix_version['id']
                    if 'assignee' in current_release_issue:
                        release_dict['assignee'] = current_release_issue['assignee']['id']
                    if 'storyPoints' in current_release_issue:
                        release_dict['story_points'] = current_release_issue['storyPoints']
                    else:
                        release_dict['story_points'] = 0
                    if 'spentSp' in current_release_issue:
                        release_dict['spent_sp'] = current_release_issue['spentSp']
                    if 'sprint' in current_release_issue:
                        release_dict['sprint_id'] = current_release_issue['sprint'][0]['id']
                        release_dict['sprint_name'] = current_release_issue['sprint'][0]['display']
                    for change in parsed_issue_changelog:
                        for field in change['fields']:
                            if field['field']['id'] == 'status' and 'to' in field:
                                if 'key' in field['to']:
                                    if field['to']['key'] == 'closed':
                                        release_dict['fielddate'] = str(change['updatedAt'][0:19])
                    if current_release_issue['type']['key'] == 'release':
                        release_dict['is_release'] = 1
                        if 'qaSpent' in current_release_issue:
                            release_dict['qa_release_time'] = count_qa_spent_time(current_release_issue['qaSpent'])
                        changing_release_rftime = []
                        for change in parsed_issue_changelog:
                            for field in change['fields']:
                                if field['field']['id'] == 'status':
                                    if 'to' in field:
                                        if 'key' in field['to']:
                                            if field['to']['key'] == 'readyForTest':
                                                changing_release_rftime.append(change['updatedAt'][0:19])
                                    if 'from' in field:
                                        if field['from']:
                                            if 'key' in field['from']:
                                                if field['from']['key'] == 'readyForTest':
                                                    changing_release_rftime.append(change['updatedAt'][0:19])
                        release_dict['rft_time'] = count_work_hours(changing_release_rftime)
                    else:
                        changing_issue_rftime = []
                        changing_issue_in_work_time = []
                        for change in parsed_issue_changelog:
                            if 'fields' in change:
                                for field in change['fields']:
                                    if field['field']['id'] == 'status':
                                        if 'to' in field:
                                            if 'key' in field['to']:
                                                if field['to']['key'] == 'readyForTest':
                                                    changing_issue_rftime.append(change['updatedAt'][0:19])
                                                if field['to']['key'] == 'inProgress':
                                                    changing_issue_in_work_time.append(change['updatedAt'][0:19])
                                        if 'from' in field:
                                            if field['from']:
                                                if 'key' in field['from']:
                                                    if field['from']['key'] == 'readyForTest':
                                                        changing_issue_rftime.append(change['updatedAt'][0:19])
                                                    if field['from']['key'] == 'inProgress':
                                                        changing_issue_in_work_time.append(change['updatedAt'][0:19])
                        release_dict['rft_time'] = count_work_hours(changing_issue_rftime)
                        release_dict['in_work_time'] = count_work_hours(changing_issue_in_work_time)
                        if 'qaSpent' in current_release_issue:
                            release_dict['qa_time'] = count_qa_spent_time(current_release_issue['qaSpent'])
                        elif 'qaTspSpent' in current_release_issue:
                            if current_release_issue['qaTspSpent'] == 1:
                                release_dict['qa_time'] = 3 * 60
                            elif current_release_issue['qaTspSpent'] == 2:
                                release_dict['qa_time'] = 5 * 60
                            elif current_release_issue['qaTspSpent'] == 3:
                                release_dict['qa_time'] = 8 * 60
                        if 'spentSp' in current_release_issue:
                            if current_release_issue['spentSp'] == 1:
                                release_dict['sp_time'] = 3 * 60
                            elif current_release_issue['spentSp'] == 2:
                                release_dict['sp_time'] = 5 * 60
                            elif current_release_issue['spentSp'] == 3:
                                release_dict['sp_time'] = 8 * 60
                            elif current_release_issue['spentSp'] == 4:
                                release_dict['sp_time'] = 16 * 60
                            elif current_release_issue['spentSp'] == 5:
                                release_dict['sp_time'] = 24 * 60
                            elif current_release_issue['spentSp'] > 5:
                                release_dict['sp_time'] = int(current_release_issue['spentSp'] * 5) * 60
                    if 'fielddate' in release_dict:
                        ocrm_release_list.append(release_dict)

        # count oCRM sprints statistics
        logging.info('count oCRM sprints statistics')
        ocrm_sprints_list = []
        parsed_sprints = get_json_data(st_session, url_ocrm_st_sprints)
        for sprint in parsed_sprints:
            if sprint['id'] > 40196 and sprint['archived']:
                parsed_issues_in_sprint = get_json_data(
                    st_session,
                    url_ocrm_st_issues_in_sprint + str(sprint['id'])
                )
                for current_issue in parsed_issues_in_sprint:
                    sprint_dict = {}
                    parsed_issue_changelog = get_json_data(
                        st_session,
                        str(current_issue['self']) + '/changelog?field=status'
                    )
                    sprint_dict['issue'] = ['Все спринты', sprint['name'], current_issue['key']]
                    changing_issue_in_work_time = []
                    for change in parsed_issue_changelog:
                        if 'fields' in change:
                            for field in change['fields']:
                                if field['field']['id'] == 'status':
                                    if 'to' in field:
                                        if 'key' in field['to']:
                                            if field['to']['key'] == 'inProgress':
                                                changing_issue_in_work_time.append(change['updatedAt'][0:19])
                                            if field['to']['key'] == 'closed':
                                                sprint_dict['fielddate'] = str(change['updatedAt'][0:19])
                                    if 'from' in field:
                                        if field['from']:
                                            if 'key' in field['from']:
                                                if field['from']['key'] == 'inProgress':
                                                    changing_issue_in_work_time.append(change['updatedAt'][0:19])
                    sprint_dict['in_work_time'] = count_work_hours(changing_issue_in_work_time)
                    if 'storyPoints' in current_issue:
                        sprint_dict['story_points'] = current_issue['storyPoints']
                    else:
                        sprint_dict['story_points'] = 0
                    if 'spentSp' in current_issue:
                        sprint_dict['spent_sp'] = current_issue['spentSp']
                    if 'sprint' in current_issue:
                        sprint_dict['sprint_id'] = current_issue['sprint'][0]['id']
                        sprint_dict['sprint_name'] = current_issue['sprint'][0]['display']
                    if 'assignee' in current_issue:
                        sprint_dict['assignee'] = current_issue['assignee']['id']
                    if 'tags' in current_issue:
                        if 'frontend' in current_issue['tags']:
                            sprint_dict['is_frontend'] = 1
                    if 'fielddate' in sprint_dict:
                        ocrm_sprints_list.append(sprint_dict)

        # sugarCRM
        # count SugarCRM autotests persentage
        logging.info('count SugarCRM autotests persentage')
        scrm_cases_autpmated = 0
        tp_scrm_suite_autotests = get_json_data(testpalm_session, url_testpalm_scrm_autotest)
        for values_automated in tp_scrm_suite_autotests['groups']:
            scrm_cases_autpmated += values_automated['count']
        scrm_cases_all = 0
        tp_scrm_suite_all = get_json_data(testpalm_session, url_testpalm_scrm_all)
        for values_all in tp_scrm_suite_all['groups']:
            scrm_cases_all += values_all['count']
        scrm_autotests_percentage_to_stat = {
            'fielddate': str(datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')),
            'automated_issues': str(scrm_cases_autpmated),
            'all_issues': str(scrm_cases_all)
        }

        # send to STAT
        report_names = {
            '/Market/CRM/testing/ocrm-rft': [ocrm_rft_to_stat],
            'Market/CRM/testing/bugsoCRM': ocrm_bad_issues,
            'Market/CRM/testing/resolvedBugsoCRM': resolved_ocrm_issues,
            'Market/CRM/testing/ocrm_releases': ocrm_release_list,
            'Market/CRM/management/ocrm_sprints': ocrm_sprints_list,
            'Market/CRM/testing/shugarCRM_automated_stat': [scrm_autotests_percentage_to_stat],
        }
        scale = 's'
        for name in report_names:
            strr_d = json.dumps({"values": list(reversed(report_names[name]))})
            r = requests.post(
                'https://upload.stat.yandex-team.ru/_api/report/data',
                headers={'Authorization': 'OAuth {}'.format(stat_token)},
                data={
                    'name': name,
                    'scale': scale,
                    'data': strr_d,
                },
                verify=False,
            )
            logging.info(name)
            logging.info(r)
